/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import net.minecraft.class_9022;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.ScoreFormat;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.scoreboard.SpongeObjective;

public final class SpongeScore
implements Score {
    private final String name;
    public class_9015 holder;
    private int score;
    private boolean locked;
    @Nullable
    private class_2561 display;
    @Nullable
    private class_9022 numberFormat;
    private Set<class_266> objectives = new HashSet<class_266>();

    public SpongeScore(String name) {
        this.name = name;
        this.holder = class_9015.method_55422((String)name);
    }

    public SpongeScore(GameProfile profile) {
        this.holder = class_9015.method_55420((com.mojang.authlib.GameProfile)SpongeGameProfile.toMcProfile(profile));
        this.name = this.holder.method_5820();
    }

    public SpongeScore(Entity entity) {
        this.holder = (class_1297)entity;
        this.name = this.holder.method_5820();
    }

    public String name() {
        return this.name;
    }

    public int score() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
        this.updateScore();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.updateScore();
    }

    public void setDisplay(Component display) {
        this.display = SpongeAdventure.asVanilla(display);
        this.updateScore();
    }

    public Optional<Component> display() {
        return Optional.ofNullable(this.display == null ? null : SpongeAdventure.asAdventure(this.display));
    }

    public void setNumberFormat(@org.checkerframework.checker.nullness.qual.Nullable ScoreFormat format) {
        this.numberFormat = (class_9022)format;
        this.updateScore();
    }

    public Optional<ScoreFormat> numberFormat() {
        return Optional.ofNullable((ScoreFormat)this.numberFormat);
    }

    private void updateScore() {
        for (class_266 objective : this.objectives) {
            class_269 scoreboard = objective.method_1117();
            class_9014 access = scoreboard.method_1180(this.holder, objective);
            this.registerAndUpdate(objective, access);
        }
    }

    public Set<Objective> objectives() {
        HashSet<Objective> objectives = new HashSet<Objective>();
        for (class_266 objective : this.objectives) {
            objectives.add(((ObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return objectives;
    }

    public void registerAndUpdate(class_266 objective, class_9014 accessor) {
        this.objectives.add(objective);
        accessor.method_55410(this.score);
        accessor.method_55411(this.display);
        accessor.method_55412(this.numberFormat);
        if (this.locked) {
            accessor.method_55418();
        } else {
            accessor.method_55417();
        }
    }

    public void unregister(class_266 objective) {
        this.objectives.remove(objective);
    }

    public record SpongeScoreAccess(class_9015 holder, class_266 objective, class_9014 access) implements class_9014
    {
        public int method_55409() {
            return this.access.method_55409();
        }

        public boolean method_55416() {
            return this.access.method_55416();
        }

        @Nullable
        public class_2561 method_55419() {
            return this.access.method_55419();
        }

        public void method_55410(int var1) {
            SpongeObjective spongeObjective = ((ObjectiveBridge)this.objective).bridge$getSpongeObjective();
            spongeObjective.findScore(this.holder.method_5820()).ifPresent(spongeScore -> {
                if (spongeScore.score() != var1) {
                    spongeScore.setScore(var1);
                }
            });
            this.access.method_55410(var1);
        }

        public void method_55417() {
            SpongeObjective spongeObjective = ((ObjectiveBridge)this.objective).bridge$getSpongeObjective();
            spongeObjective.findScore(this.holder.method_5820()).ifPresent(spongeScore -> {
                if (spongeScore.isLocked()) {
                    spongeScore.setLocked(false);
                }
            });
            this.access.method_55417();
        }

        public void method_55418() {
            SpongeObjective spongeObjective = ((ObjectiveBridge)this.objective).bridge$getSpongeObjective();
            spongeObjective.findScore(this.holder.method_5820()).ifPresent(spongeScore -> {
                if (!spongeScore.isLocked()) {
                    spongeScore.setLocked(true);
                }
            });
            this.access.method_55418();
        }

        public void method_55411(@Nullable class_2561 var1) {
            SpongeObjective spongeObjective = ((ObjectiveBridge)this.objective).bridge$getSpongeObjective();
            spongeObjective.findScore(this.holder.method_5820()).ifPresent(spongeScore -> {
                if (spongeScore.display().isEmpty() && var1 == null) {
                    return;
                }
                if (var1 == null) {
                    spongeScore.setDisplay(null);
                    return;
                }
                Component component = SpongeAdventure.asAdventure(var1);
                if (Objects.equals(spongeScore.display().orElse(null), component)) {
                    return;
                }
                spongeScore.setDisplay(component);
            });
            this.access.method_55411(var1);
        }

        public void method_55412(@Nullable class_9022 var1) {
            this.access.method_55412(var1);
        }
    }
}

