/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard.builder;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.class_268;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.scoreboard.CollisionRule;
import org.spongepowered.api.scoreboard.CollisionRules;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.Visibilities;
import org.spongepowered.api.scoreboard.Visibility;
import org.spongepowered.common.util.Preconditions;

public final class SpongeTeamBuilder
implements Team.Builder {
    private @Nullable String name;
    private @Nullable Component displayName;
    private NamedTextColor color;
    private Component prefix;
    private Component suffix;
    private boolean allowFriendlyFire;
    private boolean showFriendlyInvisibles;
    private Supplier<? extends Visibility> nameTagVisibility;
    private Supplier<? extends Visibility> deathMessageVisibility;
    private Supplier<? extends CollisionRule> collisionRule;
    private Set<Component> members;

    public SpongeTeamBuilder() {
        this.reset();
    }

    public Team.Builder name(String name) {
        this.name = Objects.requireNonNull(name, "Name cannot be null!");
        if (this.displayName == null) {
            this.displayName = Component.text((String)this.name);
        }
        return this;
    }

    public Team.Builder color(NamedTextColor color) {
        Objects.requireNonNull(color, "Color cannot be null!");
        this.color = color;
        return this;
    }

    public Team.Builder displayName(Component displayName) throws IllegalArgumentException {
        this.displayName = Objects.requireNonNull(displayName, "DisplayName cannot be null!");
        return this;
    }

    public Team.Builder prefix(Component prefix) {
        this.prefix = Objects.requireNonNull(prefix, "Prefix cannot be null!");
        return this;
    }

    public Team.Builder suffix(Component suffix) {
        this.suffix = Objects.requireNonNull(suffix, "Suffix cannot be null!");
        return this;
    }

    public Team.Builder allowFriendlyFire(boolean enabled) {
        this.allowFriendlyFire = enabled;
        return this;
    }

    public Team.Builder canSeeFriendlyInvisibles(boolean enabled) {
        this.showFriendlyInvisibles = enabled;
        return this;
    }

    public Team.Builder nameTagVisibility(Visibility visibility) {
        Objects.requireNonNull(visibility, "Visibility cannot be null!");
        this.nameTagVisibility = () -> visibility;
        return this;
    }

    public Team.Builder deathTextVisibility(Visibility visibility) {
        Objects.requireNonNull(visibility, "Visibility cannot be null!");
        this.deathMessageVisibility = () -> visibility;
        return this;
    }

    public Team.Builder collisionRule(CollisionRule rule) {
        Objects.requireNonNull(rule, "Collision rule cannot be null!");
        this.collisionRule = () -> rule;
        return this;
    }

    public Team.Builder members(Set<Component> members) {
        this.members = new HashSet<Component>((Collection)Objects.requireNonNull(members, "Members cannot be null!"));
        return this;
    }

    public Team.Builder from(Team value) {
        this.name(value.name()).displayName(value.displayName()).prefix(value.prefix()).color(value.color()).allowFriendlyFire(value.allowFriendlyFire()).canSeeFriendlyInvisibles(value.canSeeFriendlyInvisibles()).suffix(value.suffix()).nameTagVisibility(value.nameTagVisibility()).deathTextVisibility(value.deathMessageVisibility()).collisionRule(value.collisionRule()).members(value.members());
        return this;
    }

    public SpongeTeamBuilder reset() {
        this.name = null;
        this.displayName = null;
        this.color = NamedTextColor.WHITE;
        this.prefix = Component.empty();
        this.suffix = Component.empty();
        this.allowFriendlyFire = false;
        this.showFriendlyInvisibles = false;
        this.nameTagVisibility = Visibilities.ALWAYS;
        this.deathMessageVisibility = Visibilities.ALWAYS;
        this.collisionRule = CollisionRules.ALWAYS;
        this.members = new HashSet<Component>();
        return this;
    }

    public Team build() throws IllegalStateException {
        Preconditions.checkState(this.name != null, "Name cannot be null!");
        Preconditions.checkState(this.displayName != null, "DisplayName cannot be null!");
        Team team = (Team)new class_268(null, this.name);
        team.setDisplayName(this.displayName);
        team.setColor(this.color);
        team.setPrefix(this.prefix);
        team.setSuffix(this.suffix);
        team.setAllowFriendlyFire(this.allowFriendlyFire);
        team.setCanSeeFriendlyInvisibles(this.showFriendlyInvisibles);
        team.setNameTagVisibility(this.nameTagVisibility.get());
        team.setDeathMessageVisibility(this.deathMessageVisibility.get());
        team.setCollisionRule(this.collisionRule.get());
        for (Component member : this.members) {
            team.addMember(member);
        }
        return team;
    }
}

