/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.serialization;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Locale;

public final class EnumCodec<E extends Enum<E>>
implements Codec<E> {
    private final Class<E> type;

    public static <T extends Enum<T>> EnumCodec<T> create(Class<T> type) {
        return new EnumCodec<T>(type);
    }

    public EnumCodec(Class<E> type) {
        this.type = type;
    }

    public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getStringValue(input).map(v -> Pair.of(Enum.valueOf(this.type, v.toUpperCase(Locale.ROOT)), (Object)ops.empty()));
    }

    public <T> DataResult<T> encode(E input, DynamicOps<T> ops, T prefix) {
        return ops.mergeToPrimitive(prefix, ops.createString(((Enum)input).name().toLowerCase(Locale.ROOT)));
    }
}

