/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Game;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.service.ServiceProvider;
import org.spongepowered.api.service.ServiceRegistration;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.config.common.ServicesCategory;
import org.spongepowered.common.config.core.SpongeConfigs;
import org.spongepowered.common.event.lifecycle.AbstractProvideServiceEventImpl;
import org.spongepowered.common.event.manager.SpongeEventManager;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.plugin.PluginContainer;

public abstract class SpongeServiceProvider
implements ServiceProvider {
    private final Game game;
    private final Injector injector;
    private final Map<Class<?>, Registration<?>> services = new HashMap();

    @Inject
    public SpongeServiceProvider(Game game, Injector injector) {
        this.game = game;
        this.injector = injector;
    }

    protected final Game getGame() {
        return this.game;
    }

    protected abstract List<Service<?>> servicesToSelect();

    public final <T> @NonNull Optional<T> provide(@NonNull Class<T> serviceClass) {
        Registration<?> registration = this.services.get(serviceClass);
        if (registration != null) {
            return Optional.of(registration.service());
        }
        return Optional.empty();
    }

    public final <T> @NonNull Optional<ServiceRegistration<T>> registration(@NonNull Class<T> serviceClass) {
        return Optional.ofNullable((ServiceRegistration)this.services.get(serviceClass));
    }

    protected final <T> @NonNull T provideUnchecked(Class<T> serviceClass) {
        Registration<?> registration = this.services.get(serviceClass);
        if (registration != null) {
            return (T)registration.service();
        }
        throw new IllegalStateException("Service registration does not exist.");
    }

    public final void init() {
        if (!this.services.isEmpty()) {
            throw new IllegalStateException("Services have already been initialised");
        }
        ServicesCategory.ServicePluginSubCategory servicePluginSubCategory = SpongeConfigs.getCommon().get().services.plugins;
        for (Service<?> candidate : this.servicesToSelect()) {
            String pluginId = candidate.providePluginId(servicePluginSubCategory);
            boolean isSpecific = !pluginId.isEmpty() && !pluginId.equals("?");
            Class<?> serviceClass = candidate.getServiceClass();
            String serviceName = serviceClass.getSimpleName();
            Registration<?> registration = null;
            if (isSpecific) {
                Optional specificPluginContainer = ((Launch)Launch.instance()).pluginManager().plugin(pluginId);
                if (specificPluginContainer.isPresent()) {
                    registration = this.getSpecificRegistration((PluginContainer)specificPluginContainer.get(), candidate);
                    if (registration == null) {
                        prettyPrinter = new PrettyPrinter(80).add("Service Registration Failed: %s (Service Not Provided)", serviceName).hr().addWrapped("Sponge is configured to obtain the service %s from the plugin with ID %s,however, that plugin did not provide any service implementation when requested.", serviceName, pluginId).add().add("To fix this problem, do one of the following:").add().add(" * Check that the plugin %s can actually provide the service (check the plugin   documentation if you need more assistance with that plugin).", pluginId).add(" * Set the config entry for this service to \"?\" to let Sponge find another    plugin to provide the service.").add(" * Set the config entry for this service to the ID of another plugin that can   provide the service.");
                        if (candidate.suppliesDefault()) {
                            prettyPrinter.add().add("Sponge will continue using the inbuilt default service.");
                        }
                        prettyPrinter.log(SpongeCommon.logger(), Level.ERROR);
                    }
                } else {
                    prettyPrinter = new PrettyPrinter(80).add("Service Registration Failed: %s (Plugin Not Found)", serviceName).hr().addWrapped("Sponge is configured to obtain the service %s from the plugin with ID %s,however, that plugin isn't installed.", serviceName, pluginId).add().add("To fix this problem, do one of the following:").add().add(" * Install the plugin %s", pluginId).add(" * Set the config entry for this service to \"?\" to let Sponge find another    plugin to provide the service.").add(" * Set the config entry for this service to the ID of another plugin that can   provide the service.");
                    if (candidate.suppliesDefault()) {
                        prettyPrinter.add().add("Sponge will continue using the inbuilt default service.");
                    }
                    prettyPrinter.log(SpongeCommon.logger(), Level.ERROR);
                }
            } else {
                Collection toQuery = ((Launch)Launch.instance()).pluginManager().plugins();
                registration = this.attemptRegistration(toQuery, candidate);
            }
            if (registration == null) {
                registration = this.createRegistration(candidate, ((Launch)Launch.instance()).commonPlugin());
            }
            if (registration == null) continue;
            this.services.put(candidate.getServiceClass(), registration);
            SpongeCommon.logger().info("Registered service [{}] to plugin '{}'.", (Object)registration.clazz.getSimpleName(), (Object)registration.pluginContainer.metadata().id());
        }
    }

    private <T> @Nullable Registration<T> attemptRegistration(Collection<PluginContainer> pluginContainers, Service<T> service) {
        Registration<T> registration = null;
        Iterator<PluginContainer> pluginContainerIterator = pluginContainers.iterator();
        while (registration == null && pluginContainerIterator.hasNext()) {
            PluginContainer pluginContainer = pluginContainerIterator.next();
            if (((Launch)Launch.instance()).launcherPlugins().contains(pluginContainer)) continue;
            registration = this.getSpecificRegistration(pluginContainer, service);
        }
        return registration;
    }

    protected abstract <T> AbstractProvideServiceEventImpl<T> createEvent(PluginContainer var1, Service<T> var2);

    private <T> @Nullable Registration<T> getSpecificRegistration(PluginContainer container, Service<T> service) {
        AbstractProvideServiceEventImpl<T> event = this.createEvent(container, service);
        try {
            ((SpongeEventManager)this.getGame().eventManager()).postToPlugin((Event)event, container);
        }
        catch (Exception ex) {
            SpongeCommon.logger().error("Failed to post ProvideServiceEvent for service {} to plugin {}.", (Object)service.getServiceClass().getSimpleName(), (Object)container.metadata().id(), (Object)ex);
        }
        if (event.getSuggestion() != null) {
            try {
                return new Registration<T>(service.getServiceClass(), event.getSuggestion().get(), container);
            }
            catch (Throwable e) {
                SpongeCommon.logger().error("Could not create service {} from plugin {}.", (Object)service.getServiceClass().getSimpleName(), (Object)container.metadata().id(), (Object)e);
            }
        }
        return null;
    }

    private <T> @Nullable Registration<T> createRegistration(Service<T> service, PluginContainer container) {
        T impl = service.provideDefaultService(this.injector);
        if (impl == null) {
            return null;
        }
        return new Registration<T>(service.getServiceClass(), impl, container);
    }

    static final class Registration<T>
    implements ServiceRegistration<T> {
        private final Class<T> clazz;
        private final T object;
        private final PluginContainer pluginContainer;

        private Registration(Class<T> clazz, T object, PluginContainer pluginContainer) {
            this.clazz = clazz;
            this.object = Objects.requireNonNull(object, "The service must have an implementation!");
            this.pluginContainer = pluginContainer;
        }

        public @NonNull Class<T> serviceClass() {
            return this.clazz;
        }

        public @NonNull T service() {
            return this.object;
        }

        public @NonNull PluginContainer pluginContainer() {
            return this.pluginContainer;
        }
    }

    protected static final class Service<T> {
        private final @NonNull Class<T> service;
        private final @Nullable Class<? extends T> defaultServiceClass;
        private final @NonNull Function<ServicesCategory.ServicePluginSubCategory, String> configEntryProvider;

        public Service(@NonNull Class<T> service, @NonNull Function<ServicesCategory.ServicePluginSubCategory, String> configEntryProvider, @Nullable Class<? extends T> defaultServiceClass) {
            this.service = service;
            this.defaultServiceClass = defaultServiceClass;
            this.configEntryProvider = configEntryProvider;
        }

        public Class<T> getServiceClass() {
            return this.service;
        }

        public String providePluginId(ServicesCategory.ServicePluginSubCategory servicePluginSubCategory) {
            return this.configEntryProvider.apply(servicePluginSubCategory);
        }

        public boolean suppliesDefault() {
            return this.defaultServiceClass != null;
        }

        public @Nullable T provideDefaultService(Injector injector) {
            if (this.defaultServiceClass != null) {
                return (T)injector.getInstance(this.defaultServiceClass);
            }
            return null;
        }
    }
}

