/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.game.pagination;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.common.service.game.pagination.SpongePaginationList;
import org.spongepowered.common.service.game.pagination.SpongePaginationService;
import org.spongepowered.common.util.Preconditions;

public final class SpongePaginationBuilder
implements PaginationList.Builder {
    static final Component DEFAULT_PADDING = Component.text((String)"=");
    private final SpongePaginationService service;
    private @Nullable Iterable<Component> contents;
    private @Nullable Component title;
    private @Nullable Component header;
    private @Nullable Component footer;
    private Component paginationSpacer = DEFAULT_PADDING;
    private int linesPerPage = 20;
    private @Nullable PaginationList paginationList;

    public SpongePaginationBuilder(SpongePaginationService service) {
        this.service = service;
    }

    public PaginationList.Builder contents(Iterable<Component> contents) {
        Objects.requireNonNull(contents, "The contents cannot be null!");
        this.contents = contents;
        this.paginationList = null;
        return this;
    }

    public PaginationList.Builder contents(Component ... contents) {
        Objects.requireNonNull(contents, "The contents cannot be null!");
        this.contents = ImmutableList.copyOf((Object[])contents);
        this.paginationList = null;
        return this;
    }

    public PaginationList.Builder title(@Nullable Component title) {
        this.title = title;
        this.paginationList = null;
        return this;
    }

    public PaginationList.Builder header(@Nullable Component header) {
        this.header = header;
        this.paginationList = null;
        return this;
    }

    public PaginationList.Builder footer(@Nullable Component footer) {
        this.footer = footer;
        this.paginationList = null;
        return this;
    }

    public PaginationList.Builder padding(Component padding) {
        Objects.requireNonNull(padding, "The padding cannot be null!");
        this.paginationSpacer = padding;
        this.paginationList = null;
        return this;
    }

    public PaginationList.Builder linesPerPage(int linesPerPage) {
        this.linesPerPage = linesPerPage;
        return this;
    }

    public PaginationList build() {
        Preconditions.checkState(this.contents != null, "The contents of the pagination list cannot be null!");
        if (this.paginationList == null) {
            this.paginationList = new SpongePaginationList(this.service, this.contents, this.title, this.header, this.footer, this.paginationSpacer, this.linesPerPage);
        }
        return this.paginationList;
    }

    public PaginationList.Builder from(PaginationList list) {
        this.reset();
        this.contents = list.contents();
        this.title = list.title().orElse(null);
        this.header = list.header().orElse(null);
        this.footer = list.footer().orElse(null);
        this.paginationSpacer = list.padding();
        this.paginationList = null;
        return this;
    }

    public PaginationList.Builder reset() {
        this.contents = null;
        this.title = null;
        this.header = null;
        this.footer = null;
        this.paginationSpacer = DEFAULT_PADDING;
        this.paginationList = null;
        return this;
    }
}

