/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.game.pagination;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.common.service.game.pagination.ActivePagination;
import org.spongepowered.common.service.game.pagination.IterablePagination;
import org.spongepowered.common.service.game.pagination.ListPagination;
import org.spongepowered.common.service.game.pagination.PaginationCalculator;
import org.spongepowered.common.service.game.pagination.SpongePaginationService;

public final class SpongePaginationList
implements PaginationList {
    private final SpongePaginationService service;
    private final Iterable<Component> contents;
    private final Component title;
    private final Component header;
    private final Component footer;
    private final Component paginationSpacer;
    private final int linesPerPage;

    public SpongePaginationList(SpongePaginationService service, Iterable<Component> contents, @Nullable Component title, @Nullable Component header, @Nullable Component footer, Component paginationSpacer, int linesPerPage) {
        this.service = service;
        this.contents = contents;
        this.title = title;
        this.header = header;
        this.footer = footer;
        this.paginationSpacer = paginationSpacer;
        this.linesPerPage = linesPerPage;
    }

    public Iterable<Component> contents() {
        return this.contents;
    }

    public Optional<Component> title() {
        return Optional.ofNullable(this.title);
    }

    public Optional<Component> header() {
        return Optional.ofNullable(this.header);
    }

    public Optional<Component> footer() {
        return Optional.ofNullable(this.footer);
    }

    public Component padding() {
        return this.paginationSpacer;
    }

    public int linesPerPage() {
        return this.linesPerPage;
    }

    public void sendTo(Audience receiver, int page) {
        block5: {
            Supplier<Optional<? extends Audience>> audienceSupplier;
            Objects.requireNonNull(receiver, "The message receiver cannot be null!");
            PaginationCalculator calculator = new PaginationCalculator(this.linesPerPage);
            Iterable counts = StreamSupport.stream(this.contents.spliterator(), false).map(input -> {
                int lines = calculator.getLines((Component)input);
                return Maps.immutableEntry((Object)input, (Object)lines);
            }).collect(Collectors.toList());
            Component title = this.title;
            if (title != null) {
                title = calculator.center(title, this.paginationSpacer);
            }
            if (receiver instanceof Player) {
                UUID playerUuid = ((Player)receiver).uniqueId();
                audienceSupplier = () -> Sponge.server().player(playerUuid);
            } else {
                WeakReference<Audience> srcReference = new WeakReference<Audience>(receiver);
                audienceSupplier = () -> Optional.ofNullable((Audience)srcReference.get());
            }
            ActivePagination pagination = this.contents instanceof List ? new ListPagination(audienceSupplier, calculator, (List<Map.Entry<Component, Integer>>)ImmutableList.copyOf((Iterable)counts), title, this.header, this.footer, this.paginationSpacer) : new IterablePagination(audienceSupplier, calculator, counts, title, this.header, this.footer, this.paginationSpacer);
            this.service.getPaginationState(receiver, true).put(pagination);
            try {
                pagination.specificPage(page);
            }
            catch (CommandException e) {
                Component text = e.componentMessage();
                if (text == null) break block5;
                receiver.sendMessage(Identity.nil(), text.color((TextColor)NamedTextColor.RED));
            }
        }
    }
}

