/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.ban;

import com.google.inject.Singleton;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_3317;
import net.minecraft.class_3330;
import net.minecraft.class_3335;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.ban.BanTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.players.IpBanListAccessor;
import org.spongepowered.common.accessor.server.players.StoredUserListAccessor;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.UserListUtil;

@Singleton
public final class SpongeBanService
implements BanService {
    public CompletableFuture<Collection<? extends Ban>> bans() {
        Collection<Ban.Profile> bans = this.profileBans().join();
        Collection<Ban.IP> ipBans = this.ipBans().join();
        ArrayList<Object> list = new ArrayList<Object>(bans.size() + ipBans.size());
        list.addAll(bans);
        list.addAll(ipBans);
        return CompletableFuture.completedFuture(Collections.unmodifiableCollection(list));
    }

    public CompletableFuture<Collection<Ban.Profile>> profileBans() {
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getUserBanList();
        accessor.invoker$removeExpired();
        return CompletableFuture.completedFuture(Collections.unmodifiableCollection(new ArrayList(accessor.accessor$map().values())));
    }

    public CompletableFuture<Collection<Ban.IP>> ipBans() {
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getIPBanList();
        accessor.invoker$removeExpired();
        return CompletableFuture.completedFuture(Collections.unmodifiableCollection(new ArrayList(accessor.accessor$map().values())));
    }

    public CompletableFuture<Optional<Ban.Profile>> find(GameProfile profile) {
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getUserBanList();
        accessor.invoker$removeExpired();
        return CompletableFuture.completedFuture(Optional.ofNullable((Ban.Profile)accessor.accessor$map().get(accessor.invoker$getKeyForUser(SpongeGameProfile.toMcProfile(profile)))));
    }

    public CompletableFuture<Optional<Ban.IP>> find(InetAddress address) {
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getIPBanList();
        accessor.invoker$removeExpired();
        return CompletableFuture.completedFuture(Optional.ofNullable((Ban.IP)accessor.accessor$map().get(accessor.invoker$getKeyForUser(((IpBanListAccessor)((Object)accessor)).invoker$getIpFromAddress(new InetSocketAddress(address, 0))))));
    }

    public boolean isBanned(GameProfile profile) {
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getUserBanList();
        accessor.invoker$removeExpired();
        return accessor.accessor$map().containsKey(accessor.invoker$getKeyForUser(SpongeGameProfile.toMcProfile(profile)));
    }

    public boolean isBanned(InetAddress address) {
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getIPBanList();
        accessor.invoker$removeExpired();
        return accessor.accessor$map().containsKey(accessor.invoker$getKeyForUser(((IpBanListAccessor)((Object)accessor)).invoker$getIpFromAddress(new InetSocketAddress(address, 0))));
    }

    public CompletableFuture<Boolean> pardon(GameProfile profile) {
        CompletableFuture<Optional<Ban.Profile>> ban = this.find(profile);
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getUserBanList();
        accessor.invoker$removeExpired();
        return ban.thenCompose(result -> result.map(this::remove).orElse(CompletableFuture.completedFuture(false)));
    }

    public CompletableFuture<Boolean> pardon(InetAddress address) {
        CompletableFuture<Optional<Ban.IP>> ban = this.find(address);
        StoredUserListAccessor accessor = (StoredUserListAccessor)this.getIPBanList();
        accessor.invoker$removeExpired();
        return ban.thenCompose(result -> result.map(this::remove).orElse(CompletableFuture.completedFuture(false)));
    }

    public CompletableFuture<Boolean> remove(Ban ban) {
        if (!this.hasBan(ban)) {
            return CompletableFuture.completedFuture(false);
        }
        if (ban.type().equals(BanTypes.PROFILE.get())) {
            return Sponge.server().userManager().loadOrCreate(((Ban.Profile)ban).profile().uuid()).thenApplyAsync(user -> {
                Sponge.eventManager().post((Event)SpongeEventFactory.createPardonUserEvent((Cause)PhaseTracker.getInstance().currentCause(), (Ban.Profile)((Ban.Profile)ban), (User)user));
                UserListUtil.removeEntry(this.getUserBanList(), SpongeGameProfile.toMcProfile(((Ban.Profile)ban).profile()));
                return true;
            }, (Executor)((MinecraftServerBridge)SpongeCommon.server()).bridge$spongeMainThreadExecutor());
        }
        if (ban.type().equals(BanTypes.IP.get())) {
            Sponge.eventManager().post((Event)SpongeEventFactory.createPardonIpEvent((Cause)PhaseTracker.getInstance().currentCause(), (Ban.IP)((Ban.IP)ban)));
            InetSocketAddress inetSocketAddress = new InetSocketAddress(((Ban.IP)ban).address(), 0);
            UserListUtil.removeEntry(this.getIPBanList(), ((IpBanListAccessor)this.getIPBanList()).invoker$getIpFromAddress(inetSocketAddress));
            return CompletableFuture.completedFuture(true);
        }
        throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.type()));
    }

    public CompletableFuture<Optional<? extends Ban>> add(Ban ban) {
        if (ban.type().equals(BanTypes.PROFILE.get())) {
            return Sponge.server().userManager().loadOrCreate(((Ban.Profile)ban).profile().uuid()).thenApplyAsync(user -> {
                Sponge.eventManager().post((Event)SpongeEventFactory.createBanUserEvent((Cause)PhaseTracker.getInstance().currentCause(), (Ban.Profile)((Ban.Profile)ban), (User)user));
                return Optional.ofNullable((Ban)UserListUtil.addEntry(this.getUserBanList(), (class_3330)ban));
            }, (Executor)((MinecraftServerBridge)SpongeCommon.server()).bridge$spongeMainThreadExecutor());
        }
        if (!ban.type().equals(BanTypes.IP.get())) {
            throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.type()));
        }
        Sponge.eventManager().post((Event)SpongeEventFactory.createBanIpEvent((Cause)PhaseTracker.getInstance().currentCause(), (Ban.IP)((Ban.IP)ban)));
        Ban prevBan = (Ban)UserListUtil.addEntry(this.getIPBanList(), (class_3330)ban);
        return CompletableFuture.completedFuture(Optional.ofNullable(prevBan));
    }

    public boolean hasBan(Ban ban) {
        if (ban.type().equals(BanTypes.PROFILE.get())) {
            return this.isBanned(((Ban.Profile)ban).profile());
        }
        if (ban.type().equals(BanTypes.IP.get())) {
            return this.isBanned(((Ban.IP)ban).address());
        }
        throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.type()));
    }

    private class_3335 getUserBanList() {
        return SpongeCommon.server().method_3760().method_14563();
    }

    private class_3317 getIPBanList() {
        return SpongeCommon.server().method_3760().method_14585();
    }
}

