/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.ban;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.class_3317;
import net.minecraft.class_3320;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.common.util.BanUtil;
import org.spongepowered.common.util.NetworkUtil;

public final class SpongeIPBanList
extends class_3317 {
    public SpongeIPBanList(File file) {
        super(file);
    }

    protected boolean contains(String entry) {
        if (entry.equals("local")) {
            return false;
        }
        try {
            return ((Optional)Sponge.server().serviceProvider().banService().find(InetAddress.getByName(entry)).join()).isPresent();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    public @Nullable class_3320 get(String obj) {
        if (obj.equals("local")) {
            return null;
        }
        try {
            return ((Optional)Sponge.server().serviceProvider().banService().find(InetAddress.getByName(obj)).join()).map(ban -> {
                if (ban instanceof class_3320) {
                    return (class_3320)ban;
                }
                LegacyComponentSerializer lcs = LegacyComponentSerializer.legacySection();
                return new class_3320(BanUtil.addressToBanCompatibleString(ban.address()), Date.from(ban.creationDate()), (String)ban.banSource().map(arg_0 -> ((LegacyComponentSerializer)lcs).serialize(arg_0)).orElse(null), (Date)ban.expirationDate().map(Date::from).orElse(null), (String)ban.reason().map(arg_0 -> ((LegacyComponentSerializer)lcs).serialize(arg_0)).orElse(null));
            }).orElse(null);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    public void remove(String entry) {
        if (entry.equals("local")) {
            return;
        }
        try {
            Sponge.server().serviceProvider().banService().pardon(InetAddress.getByName(entry)).join();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    public String[] method_14636() {
        ArrayList<String> ips = new ArrayList<String>();
        for (Ban.IP ban : (Collection)Sponge.server().serviceProvider().banService().ipBans().join()) {
            ips.add(this.method_14526(new InetSocketAddress(ban.address(), 0)));
        }
        return ips.toArray(new String[0]);
    }

    public void add(class_3320 entry) {
        Sponge.server().serviceProvider().banService().add((Ban)entry).join();
    }

    public boolean method_14641() {
        return ((Collection)Sponge.server().serviceProvider().banService().ipBans().join()).isEmpty();
    }

    public String method_14526(SocketAddress address) {
        return NetworkUtil.getHostString(address);
    }
}

