/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import net.minecraft.class_3326;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Game;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.service.server.permission.DataFactoryCollection;
import org.spongepowered.common.service.server.permission.FixedParentMemorySubjectData;
import org.spongepowered.common.service.server.permission.GlobalMemorySubjectData;
import org.spongepowered.common.service.server.permission.OpLevelCollection;
import org.spongepowered.common.service.server.permission.SpongePermissionDescription;
import org.spongepowered.common.service.server.permission.SpongeSubject;
import org.spongepowered.common.service.server.permission.SpongeSubjectCollection;
import org.spongepowered.common.service.server.permission.SpongeSubjectReference;
import org.spongepowered.common.service.server.permission.UserCollection;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class SpongePermissionService
implements PermissionService {
    private static final String SUBJECTS_DEFAULT = "default";
    private final Game game;
    private final Map<String, PermissionDescription> descriptionMap = new LinkedHashMap<String, PermissionDescription>();
    private @Nullable Collection<PermissionDescription> descriptions;
    private final ConcurrentMap<String, SpongeSubjectCollection> subjects = new ConcurrentHashMap<String, SpongeSubjectCollection>();
    private final SpongeSubjectCollection defaultCollection;
    private final SpongeSubject defaultData;

    @Inject
    public SpongePermissionService(Game game) {
        this.game = game;
        this.defaultCollection = this.newCollection(SUBJECTS_DEFAULT);
        this.subjects.put(SUBJECTS_DEFAULT, this.defaultCollection);
        this.subjects.put("user", new UserCollection(this));
        this.subjects.put("group", new OpLevelCollection(this));
        this.subjects.put("commandblock", new DataFactoryCollection("commandblock", this, s -> new FixedParentMemorySubjectData((Subject)s, this.getGroupForOpLevel(2).asSubjectReference())));
        this.subjects.put("system", new DataFactoryCollection("system", this, s -> new FixedParentMemorySubjectData((Subject)s, this.getGroupForOpLevel(4).asSubjectReference())));
        this.defaultData = this.getDefaultCollection().get(SUBJECTS_DEFAULT);
    }

    static class_3326 getOps() {
        return SpongeCommon.server().method_3760().method_14603();
    }

    static int getServerOpLevel() {
        return SpongeCommon.server().method_3798();
    }

    public Subject getGroupForOpLevel(int level) {
        return this.groupSubjects().get("op_" + level);
    }

    public SpongeSubjectCollection userSubjects() {
        return this.get("user");
    }

    public SpongeSubjectCollection groupSubjects() {
        return this.get("group");
    }

    private SpongeSubjectCollection newCollection(String identifier) {
        return new DataFactoryCollection(identifier, this, GlobalMemorySubjectData::new);
    }

    public SpongeSubjectCollection get(String identifier) {
        SpongeSubjectCollection existingRet;
        SpongeSubjectCollection ret = (SpongeSubjectCollection)this.subjects.get(identifier);
        if (ret == null && (existingRet = this.subjects.putIfAbsent(identifier, ret = this.newCollection(identifier))) != null) {
            ret = existingRet;
        }
        return ret;
    }

    public SpongeSubject defaults() {
        return this.defaultData;
    }

    public Predicate<String> identifierValidityPredicate() {
        return s -> true;
    }

    public SubjectReference newSubjectReference(String collectionIdentifier, String subjectIdentifier) {
        Objects.requireNonNull(collectionIdentifier, "collectionIdentifier");
        Objects.requireNonNull(subjectIdentifier, "subjectIdentifier");
        return new SpongeSubjectReference(this, collectionIdentifier, subjectIdentifier);
    }

    public CompletableFuture<SubjectCollection> loadCollection(String identifier) {
        return CompletableFuture.completedFuture(this.get(identifier));
    }

    public Optional<SubjectCollection> collection(String identifier) {
        return Optional.of(this.get(identifier));
    }

    public CompletableFuture<Boolean> hasCollection(String identifier) {
        return CompletableFuture.completedFuture(this.subjects.containsKey(identifier));
    }

    public Map<String, SubjectCollection> loadedCollections() {
        return ImmutableMap.copyOf(this.subjects);
    }

    public CompletableFuture<Set<String>> allIdentifiers() {
        return CompletableFuture.completedFuture(this.loadedCollections().keySet());
    }

    public PermissionDescription.Builder newDescriptionBuilder(PluginContainer container) {
        return new SpongePermissionDescription.Builder(this, container);
    }

    public void addDescription(PermissionDescription permissionDescription) {
        Objects.requireNonNull(permissionDescription, "permissionDescription");
        Objects.requireNonNull(permissionDescription.id(), "permissionId");
        this.descriptionMap.put(permissionDescription.id().toLowerCase(), permissionDescription);
        this.descriptions = null;
    }

    public Optional<PermissionDescription> description(String permissionId) {
        return Optional.ofNullable(this.descriptionMap.get(Objects.requireNonNull(permissionId, "permissionId").toLowerCase()));
    }

    public Collection<PermissionDescription> descriptions() {
        ImmutableList descriptions = this.descriptions;
        if (descriptions == null) {
            this.descriptions = descriptions = ImmutableList.copyOf(this.descriptionMap.values());
        }
        return descriptions;
    }

    public SpongeSubjectCollection getDefaultCollection() {
        return this.defaultCollection;
    }
}

