/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import java.util.Collection;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.service.server.permission.SpongePermissionService;
import org.spongepowered.common.service.server.permission.SpongeSubject;
import org.spongepowered.common.service.server.permission.SpongeSubjectCollection;
import org.spongepowered.common.service.server.permission.UserSubject;

public class UserCollection
extends SpongeSubjectCollection {
    public UserCollection(SpongePermissionService service) {
        super("user", service);
    }

    @Override
    public SpongeSubject get(String identifier) {
        UUID uuid = this.identityToUuid(identifier);
        if (uuid == null) {
            throw new IllegalArgumentException("Provided identifier must be a uuid, was " + identifier);
        }
        return this.get(this.uuidToGameProfile(uuid));
    }

    protected SpongeSubject get(com.mojang.authlib.GameProfile profile) {
        return new UserSubject(profile, this);
    }

    private com.mojang.authlib.GameProfile uuidToGameProfile(UUID uuid) {
        try {
            return SpongeGameProfile.toMcProfile((GameProfile)Sponge.server().gameProfileManager().basicProfile(uuid).get());
        }
        catch (Exception e) {
            SpongeCommon.logger().warn("Failed to lookup game profile for {}", (Object)uuid, (Object)e);
            return new com.mojang.authlib.GameProfile(uuid, null);
        }
    }

    @Override
    public boolean isRegistered(String identifier) {
        UUID uuid = this.identityToUuid(identifier);
        if (uuid == null) {
            return false;
        }
        com.mojang.authlib.GameProfile profile = new com.mojang.authlib.GameProfile(uuid, null);
        return SpongePermissionService.getOps().method_14640((Object)profile) != null;
    }

    private UUID identityToUuid(String identifier) {
        try {
            return UUID.fromString(identifier);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Collection<Subject> loadedSubjects() {
        return SpongeCommon.game().server().onlinePlayers();
    }

    public SpongePermissionService getService() {
        return this.service;
    }
}

