/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.state.State;
import org.spongepowered.api.state.StateContainer;
import org.spongepowered.api.state.StateMatcher;
import org.spongepowered.api.state.StateProperty;

public abstract class AbstractSpongeStateMatcher<S extends State<@NonNull S>, T extends StateContainer<@NonNull S>>
implements StateMatcher<S> {
    final T type;
    final Map<StateProperty<@NonNull ?>, Object> properties;
    final Collection<KeyValueMatcher<?>> keyValueMatchers;
    final Collection<StateProperty<@NonNull ?>> requiredProperties;
    protected @MonotonicNonNull List<S> compatibleStates;

    AbstractSpongeStateMatcher(T type, Collection<StateProperty<@NonNull ?>> requiredProperties, HashMap<StateProperty<@NonNull ?>, Object> properties, Collection<KeyValueMatcher<?>> keyValueMatchers) {
        this.type = type;
        this.requiredProperties = requiredProperties;
        this.properties = properties;
        this.keyValueMatchers = keyValueMatchers;
    }

    protected final boolean isValid(class_2688<?, ?> stateHolder) {
        class_2769 property;
        for (Map.Entry<StateProperty<?>, Object> entry : this.properties.entrySet()) {
            property = (class_2769)entry.getKey();
            Object value = stateHolder.method_11656().get(property);
            if (value != null && value.equals(entry.getValue())) continue;
            return false;
        }
        for (StateProperty stateProperty : this.requiredProperties) {
            property = (class_2769)stateProperty;
            if (stateHolder.method_11656().get(property) != null) continue;
            return false;
        }
        DataHolder dataHolder = (DataHolder)stateHolder;
        for (KeyValueMatcher<?> valueMatcher : this.keyValueMatchers) {
            if (this.matches(dataHolder, valueMatcher)) continue;
            return false;
        }
        return true;
    }

    private <V> boolean matches(DataHolder holder, KeyValueMatcher<V> keyValueMatcher) {
        return holder.get(keyValueMatcher.key()).map(arg_0 -> keyValueMatcher.matches(arg_0)).orElse(false);
    }
}

