/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.tag;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.api.util.Tristate;

public interface SpongePluginTagPredicate<T>
extends BiFunction<DefaultedRegistryReference<T>, Tag<T>, Tristate> {
    public static <T> SpongePluginTagPredicate<T> key(Predicate<DefaultedRegistryReference<T>> predicate) {
        return (k, t) -> {
            if (k != null) {
                return Tristate.fromBoolean((boolean)predicate.test((DefaultedRegistryReference)k));
            }
            return Tristate.UNDEFINED;
        };
    }

    public static <T> SpongePluginTagPredicate<T> tag(Predicate<Tag<T>> predicate) {
        return (k, t) -> {
            if (t != null) {
                return Tristate.fromBoolean((boolean)predicate.test((Tag)t));
            }
            return Tristate.UNDEFINED;
        };
    }

    public static <T> SpongePluginTagPredicate<T> tagKey(BiPredicate<Tag<T>, DefaultedRegistryReference<T>> predicate) {
        return (k, t) -> {
            if (k != null && t != null) {
                return Tristate.fromBoolean((boolean)predicate.test((Tag)t, (DefaultedRegistryReference)k));
            }
            return Tristate.UNDEFINED;
        };
    }

    default public SpongePluginTagPredicate<T> and(@Nullable SpongePluginTagPredicate<T> other) {
        if (other == null) {
            return this;
        }
        return (k, t) -> {
            Tristate valueThis = (Tristate)this.apply(k, t);
            Tristate valueOther = (Tristate)other.apply(k, t);
            if (valueThis == Tristate.UNDEFINED || valueOther == Tristate.UNDEFINED) {
                return Tristate.UNDEFINED;
            }
            return valueThis.and(valueOther);
        };
    }
}

