/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.tag;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3495;
import net.minecraft.class_5455;
import net.minecraft.class_7475;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.tag.TagTemplate;
import org.spongepowered.api.tag.Taggable;
import org.spongepowered.common.SpongeCommon;

public final class SpongeTagTemplate<T extends Taggable<T>>
extends Record
implements TagTemplate<T> {
    private final ResourceKey key;
    private final boolean replace;
    private final Map<ResourceKey, Boolean> elements;
    private final Map<ResourceKey, Boolean> subTags;
    private final DataPack<TagTemplate<T>> pack;

    public SpongeTagTemplate(ResourceKey key, boolean replace, Map<ResourceKey, Boolean> elements, Map<ResourceKey, Boolean> subTags, DataPack<TagTemplate<T>> pack) {
        this.key = key;
        this.replace = replace;
        this.elements = elements;
        this.subTags = subTags;
        this.pack = pack;
    }

    public int contentVersion() {
        return 1;
    }

    public DataContainer toContainer() {
        JsonObject jsonObject = SpongeTagTemplate.encode(this, (class_5455)SpongeCommon.server().method_30611());
        try {
            DataContainer container = ((StringDataFormat)DataFormats.JSON.get()).read(jsonObject.getAsString());
            container.set(DataQuery.of((String[])new String[]{"replace"}), (Object)this.replace);
            return container;
        }
        catch (IOException e) {
            SpongeCommon.logger().error("Error reading json serialized by minecraft", (Throwable)e);
            return DataContainer.createNew();
        }
    }

    public static <T extends Taggable<T>> JsonObject encode(TagTemplate<T> template, class_5455 registryAccess) {
        class_3495 builder = class_3495.method_26778();
        SpongeTagTemplate spongeTemplate = (SpongeTagTemplate)template;
        spongeTemplate.elements.forEach((k, v) -> {
            class_2960 location = (class_2960)k;
            if (v.booleanValue()) {
                builder.method_26784(location);
            } else {
                builder.method_34891(location);
            }
        });
        spongeTemplate.subTags.forEach((k, v) -> {
            class_2960 location = (class_2960)k;
            if (v.booleanValue()) {
                builder.method_26787(location);
            } else {
                builder.method_34892(location);
            }
        });
        return ((JsonElement)class_7475.field_39269.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new class_7475(builder.method_26782(), spongeTemplate.replace)).getOrThrow()).getAsJsonObject();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeTagTemplate.class, "key;replace;elements;subTags;pack", "key", "replace", "elements", "subTags", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeTagTemplate.class, "key;replace;elements;subTags;pack", "key", "replace", "elements", "subTags", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeTagTemplate.class, "key;replace;elements;subTags;pack", "key", "replace", "elements", "subTags", "pack"}, this, o);
    }

    public ResourceKey key() {
        return this.key;
    }

    public boolean replace() {
        return this.replace;
    }

    public Map<ResourceKey, Boolean> elements() {
        return this.elements;
    }

    public Map<ResourceKey, Boolean> subTags() {
        return this.subTags;
    }

    public DataPack<TagTemplate<T>> pack() {
        return this.pack;
    }
}

