/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.user;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.SpongeCommon;

final class SpongeUserFileCache {
    private final Supplier<Path> path;
    private Set<UUID> knownUniqueIds = new HashSet<UUID>();
    private @Nullable WatchService watchService = null;
    private @Nullable WatchKey watchKey = null;

    SpongeUserFileCache(Supplier<Path> path) {
        this.path = path;
    }

    public void init() {
        Path path = this.path.get();
        this.shutdownWatcher();
        try {
            this.watchService = path.getFileSystem().newWatchService();
            this.watchKey = path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (IOException e) {
            SpongeCommon.logger().warn("Could not start file watcher", (Throwable)e);
            this.shutdownWatcher();
            return;
        }
        this.scanFiles(path);
    }

    private void scanFiles(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> list = Files.list(path);){
            this.knownUniqueIds = list.map(SpongeUserFileCache::getUniqueIdFromPath).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        catch (IOException e) {
            SpongeCommon.logger().error("Failed to get player files", (Throwable)e);
            return;
        }
        this.pollFilesystemWatcher(true);
    }

    private void pollFilesystemWatcher() {
        this.pollFilesystemWatcher(false);
    }

    private void pollFilesystemWatcher(boolean initialPoll) {
        if (this.watchKey == null || !this.watchKey.isValid()) {
            if (!initialPoll) {
                this.init();
            }
            return;
        }
        HashMap<String, MutableWatchEvent> watcherUpdateMap = new HashMap<String, MutableWatchEvent>();
        for (WatchEvent<?> watchEvent : this.watchKey.pollEvents()) {
            if (watchEvent.kind() == StandardWatchEventKinds.OVERFLOW) {
                if (!initialPoll) {
                    this.scanFiles(this.path.get());
                } else {
                    this.watchKey.cancel();
                }
                return;
            }
            WatchEvent<?> ev = watchEvent;
            @Nullable Path file = (Path)ev.context();
            if (file == null) continue;
            String filename = file.getFileName().toString();
            watcherUpdateMap.computeIfAbsent(filename, f -> new MutableWatchEvent()).set(ev.kind());
        }
        for (Map.Entry entry : watcherUpdateMap.entrySet()) {
            UUID uuid;
            WatchEvent.Kind<?> kind = ((MutableWatchEvent)entry.getValue()).get();
            if (kind == null || (uuid = SpongeUserFileCache.getUniqueIdFromPath((String)entry.getKey())) == null) continue;
            if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                this.knownUniqueIds.add(uuid);
                continue;
            }
            this.knownUniqueIds.remove(uuid);
        }
    }

    public void userCreated(UUID uniqueId) {
        this.pollFilesystemWatcher();
        this.knownUniqueIds.add(uniqueId);
    }

    public boolean contains(UUID uniqueId) {
        this.pollFilesystemWatcher();
        return this.knownUniqueIds.contains(uniqueId);
    }

    public Stream<UUID> knownUUIDs() {
        this.pollFilesystemWatcher();
        return this.knownUniqueIds.stream();
    }

    public void shutdownWatcher() {
        if (this.watchKey != null) {
            this.watchKey.cancel();
            this.watchKey = null;
        }
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.watchService = null;
        }
    }

    private static @Nullable UUID getUniqueIdFromPath(Path path) {
        return SpongeUserFileCache.getUniqueIdFromPath(path.getFileName().toString());
    }

    private static @Nullable UUID getUniqueIdFromPath(String fileName) {
        String[] parts = fileName.split("\\.", 2);
        if (parts.length != 2 || parts[0].length() != 36 || !parts[1].equals("dat")) {
            return null;
        }
        try {
            return UUID.fromString(parts[0]);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    private static final class MutableWatchEvent {
        private WatchEvent.Kind<?> kind = null;

        private MutableWatchEvent() {
        }

        public @Nullable WatchEvent.Kind<?> get() {
            return this.kind;
        }

        public void set(WatchEvent.Kind<?> kind) {
            if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                kind = StandardWatchEventKinds.ENTRY_CREATE;
            }
            if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_DELETE) {
                this.kind = this.kind != null && this.kind != kind ? null : kind;
            }
        }
    }
}

