/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.user;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.class_29;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.api.user.UserManager;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.players.PlayerListAccessor;
import org.spongepowered.common.accessor.world.level.storage.PlayerDataStorageAccessor;
import org.spongepowered.common.entity.player.SpongeUserData;
import org.spongepowered.common.entity.player.SpongeUserView;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.user.SpongeUserFileCache;

public final class SpongeUserManager
implements UserManager {
    public static final UUID FAKEPLAYER_UUID = UUID.fromString("41C82C87-7AFB-4024-BA57-13D2C99CAE77");
    private final SpongeUserFileCache userFileCache;
    private final Cache<UUID, SpongeUserData> userCache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private final Set<SpongeUserData> dirtyUsers = ConcurrentHashMap.newKeySet();
    private final MinecraftServer server;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Sponge-User-Data-Loader").build());

    public SpongeUserManager(MinecraftServer server) {
        this.server = server;
        this.userFileCache = new SpongeUserFileCache(this::getSaveHandlerDirectory);
    }

    public void init() {
        this.userFileCache.init();
    }

    public CompletableFuture<Optional<User>> load(UUID uniqueId) {
        return this.fetchUser(uniqueId, false).thenApply(x -> {
            if (x != null) {
                return Optional.of(SpongeUserView.create(uniqueId));
            }
            return Optional.empty();
        });
    }

    public CompletableFuture<User> loadOrCreate(UUID uuid) {
        return this.fetchUser(uuid, true);
    }

    private CompletableFuture<@Nullable User> fetchUser(UUID uniqueId, boolean always) {
        UUID uuidToUse = this.ensureNonEmptyUUID(uniqueId);
        if (this.server.method_3760().method_14602(uniqueId) != null) {
            return CompletableFuture.completedFuture(SpongeUserView.create(uniqueId));
        }
        @Nullable SpongeUserData currentUser = (SpongeUserData)this.userCache.getIfPresent((Object)uuidToUse);
        if (currentUser != null) {
            return CompletableFuture.completedFuture(SpongeUserView.create(uuidToUse));
        }
        if (!always && !this.userFileCache.contains(uuidToUse)) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> {
            @Nullable com.mojang.authlib.GameProfile profile = this.server.method_3793().method_14512(uuidToUse).orElseGet(() -> new com.mojang.authlib.GameProfile(uuidToUse, null));
            try {
                this.createUser(profile);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            return SpongeUserView.create(uuidToUse);
        }, this.executorService);
    }

    public CompletableFuture<Optional<User>> load(String lastKnownName) {
        Objects.requireNonNull(lastKnownName, "lastKnownName");
        if (lastKnownName.isEmpty() || lastKnownName.length() > 16) {
            throw new IllegalArgumentException(String.format("Invalid username %s", lastKnownName));
        }
        @Nullable com.mojang.authlib.GameProfile mcProfile = Sponge.server().gameProfileManager().cache().findByName(lastKnownName.toLowerCase(Locale.ROOT)).map(SpongeGameProfile::toMcProfile).orElse(null);
        if (mcProfile != null) {
            return this.load(mcProfile.getId());
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    public CompletableFuture<Optional<User>> load(GameProfile profile) {
        return this.fetchUser(this.ensureNonEmptyUUID(profile.uniqueId()), false).thenApply(x -> {
            if (x != null) {
                return Optional.of(SpongeUserView.create(profile.uniqueId()));
            }
            return Optional.empty();
        });
    }

    public Stream<GameProfile> streamAll() {
        GameProfileCache cache = ((Server)this.server).gameProfileManager().cache();
        return this.userFileCache.knownUUIDs().map(x -> cache.findById(x).orElseGet(() -> GameProfile.of((UUID)x)));
    }

    public CompletableFuture<Boolean> delete(UUID uuid) {
        if (SpongeCommon.server().method_3760().method_14602(Objects.requireNonNull(uuid, "uuid")) != null) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            @Nullable Path dataFile = this.getPlayerDataFile(uuid);
            if (dataFile != null) {
                try {
                    if (Files.deleteIfExists(dataFile)) {
                        @Nullable SpongeUserData data = (SpongeUserData)this.userCache.getIfPresent((Object)uuid);
                        if (data != null) {
                            this.dirtyUsers.remove(data);
                        }
                        this.userCache.invalidate((Object)uuid);
                    }
                }
                catch (IOException | SecurityException e) {
                    SpongeCommon.logger().warn("Unable to delete file {}", (Object)dataFile, (Object)e);
                    return false;
                }
            }
            return true;
        }, this.executorService);
    }

    public boolean removeFromCache(UUID uuid) {
        @Nullable SpongeUserData data = (SpongeUserData)this.userCache.getIfPresent((Object)uuid);
        if (data != null) {
            this.dirtyUsers.remove(data);
            this.userCache.invalidate((Object)uuid);
            return true;
        }
        return false;
    }

    public CompletableFuture<Boolean> forceSave(UUID uuid) {
        @Nullable SpongeUserData data = (SpongeUserData)this.userCache.getIfPresent((Object)uuid);
        if (data != null && this.dirtyUsers.contains(data)) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    data.save();
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
                return true;
            });
        }
        return CompletableFuture.completedFuture(false);
    }

    public boolean exists(UUID playerUuid) {
        if (this.userCache.getIfPresent((Object)playerUuid) == null) {
            @Nullable Path path = this.getPlayerDataFile(playerUuid);
            return path != null && Files.exists(path, new LinkOption[0]);
        }
        return true;
    }

    public Stream<GameProfile> streamOfMatches(String lastKnownName) {
        String nameToCheck = Objects.requireNonNull(lastKnownName, "lastKnownName").toLowerCase(Locale.ROOT);
        return ((Server)this.server).gameProfileManager().cache().streamOfMatches(nameToCheck).filter(gameProfile -> this.exists(gameProfile.uuid()));
    }

    private UUID ensureNonEmptyUUID(UUID uuid) {
        if (uuid.equals(SpongeGameProfile.EMPTY_UUID)) {
            return FAKEPLAYER_UUID;
        }
        return uuid;
    }

    public void handlePlayerLogin(com.mojang.authlib.GameProfile mcProfile) throws IOException {
        @Nullable SpongeUserData currentUser = (SpongeUserData)this.userCache.getIfPresent((Object)mcProfile.getId());
        if (currentUser != null) {
            if (this.dirtyUsers.contains(currentUser)) {
                currentUser.save();
            }
            this.userCache.invalidate((Object)currentUser.uniqueId());
        }
    }

    private void createUser(com.mojang.authlib.GameProfile profile) throws IOException {
        @Nullable SpongeUserData user = SpongeUserData.create(profile);
        this.userCache.put((Object)profile.getId(), (Object)user);
        this.userFileCache.userCreated(profile.getId());
    }

    public void markDirty(SpongeUserData user) {
        if (user != this.userCache.getIfPresent((Object)user.uniqueId())) {
            SpongeCommon.logger().error("User {} is either online or the data has has dropped out of the cache and will not be saved.", (Object)user.uniqueId());
        } else {
            this.dirtyUsers.add(user);
        }
    }

    private @Nullable Path getPlayerDataFile(UUID uniqueId) {
        Path file = this.getSaveHandlerDirectory().resolve(String.valueOf(uniqueId) + ".dat");
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        return null;
    }

    private class_29 getSaveHandler() {
        return ((PlayerListAccessor)this.server.method_3760()).accessor$playerIo();
    }

    private Path getSaveHandlerDirectory() {
        return ((PlayerDataStorageAccessor)this.getSaveHandler()).accessor$playerDir().toPath();
    }

    public void saveDirtyUsers() {
        this.dirtyUsers.removeIf(SpongeUserData::isOnline);
        for (SpongeUserData user : new HashSet<SpongeUserData>(this.dirtyUsers)) {
            try {
                user.save();
            }
            catch (IOException iOException) {}
        }
    }

    public void unmarkDirty(SpongeUserData user) {
        this.dirtyUsers.remove(user);
    }

    public @Nullable SpongeUserData userFromCache(UUID uuid) {
        return (SpongeUserData)this.userCache.getIfPresent((Object)uuid);
    }

    public @Nullable User asUser(SpongeUserData spongeUserData) {
        if (this.userCache.getIfPresent((Object)spongeUserData.uniqueId()) == spongeUserData) {
            return SpongeUserView.create(spongeUserData.uniqueId());
        }
        return null;
    }
}

