/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Predicate;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2802;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierType;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.damagesource.DamageSourceBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.event.cause.entity.damage.SpongeDamageSources;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;

public final class DamageEventUtil {
    private DamageEventUtil() {
    }

    public static DamageFunction createHardHatModifier(class_1799 headItem, float multiplier) {
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(headItem);
        DamageModifier modifier = DamageEventUtil.buildDamageReductionModifier((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.HARD_HAT, snapshot);
        return new DamageFunction(modifier, damage -> damage * (double)multiplier);
    }

    public static DamageFunction createArmorModifiers(class_1309 living, class_1282 damageSource) {
        DoubleUnaryOperator function = dmg -> class_1280.method_5496((class_1309)living, (float)((float)dmg), (class_1282)damageSource, (float)living.method_6096(), (float)((float)living.method_45325(class_5134.field_23725)));
        DamageModifier modifier = DamageEventUtil.buildDamageReductionModifierWithFrame((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.ARMOR, living, class_5134.field_23725);
        return DamageFunction.of((DamageModifier)modifier, (DoubleUnaryOperator)function);
    }

    public static DamageFunction createResistanceModifier(class_1309 living) {
        class_1293 effect = living.method_6112(class_1294.field_5907);
        DamageModifier modifier = DamageEventUtil.buildDamageReductionModifier((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.DEFENSIVE_POTION_EFFECT, effect);
        return new DamageFunction(modifier, DamageEventUtil.createResistanceFunction(living));
    }

    public static DoubleUnaryOperator createResistanceFunction(class_1309 living) {
        class_1293 effect = living.method_6112(class_1294.field_5907);
        int base = effect == null ? 0 : (effect.method_5578() + 1) * 5;
        int modifier = 25 - base;
        return damage -> Math.max(damage * (double)modifier / 25.0, 0.0);
    }

    public static DamageFunction createEnchantmentModifiers(class_1309 living, float damageProtection) {
        DoubleUnaryOperator func = damage -> class_1280.method_5497((float)((float)damage), (float)damageProtection);
        DamageModifier modifier = DamageEventUtil.buildDamageReductionModifierWithFrame((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.ARMOR_ENCHANTMENT, living);
        return new DamageFunction(modifier, func);
    }

    public static DamageFunction createAbsorptionModifier(class_1309 living, float absorptionAmount) {
        DamageModifier modifier = DamageEventUtil.buildDamageReductionModifier((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.ABSORPTION, living);
        return new DamageFunction(modifier, damage -> Math.max(damage - (double)absorptionAmount, 0.0));
    }

    public static ServerLocation findFirstMatchingBlock(class_1297 entity, class_238 bb, Predicate<class_2680> predicate) {
        int i = class_3532.method_15357((double)bb.field_1323);
        int j = class_3532.method_15357((double)(bb.field_1320 + 1.0));
        int k = class_3532.method_15357((double)bb.field_1322);
        int l = class_3532.method_15357((double)(bb.field_1325 + 1.0));
        int i1 = class_3532.method_15357((double)bb.field_1321);
        int j1 = class_3532.method_15357((double)(bb.field_1324 + 1.0));
        class_2802 chunkSource = entity.method_37908().method_8398();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    class_2338 blockPos = new class_2338(k1, l1, i2);
                    class_2818 chunk = chunkSource.method_12126(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4, false);
                    if (chunk == null || chunk.method_12223() || !predicate.test(chunk.method_8320(blockPos))) continue;
                    return ServerLocation.of((ServerWorld)((ServerWorld)entity.method_37908()), (int)k1, (int)l1, (int)i2);
                }
            }
        }
        return ((Entity)entity).serverLocation();
    }

    public static void generateCauseFor(class_1282 damageSource, CauseStackManager.StackFrame frame) {
        class_1297 class_12972 = damageSource.method_5526();
        if (class_12972 instanceof Entity) {
            Entity entity = (Entity)class_12972;
            if (!(entity instanceof class_1657) && entity instanceof CreatorTrackedBridge) {
                CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)entity;
                creatorBridge.tracker$getCreatorUUID().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
                creatorBridge.tracker$getNotifierUUID().ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            }
        } else if (((DamageSourceBridge)damageSource).bridge$blockLocation() != null) {
            ServerLocation location = ((DamageSourceBridge)damageSource).bridge$blockLocation();
            class_2338 blockPos = VecHelper.toBlockPos(location);
            LevelChunkBridge chunkBridge = (LevelChunkBridge)((class_1937)location.world()).method_8500(blockPos);
            chunkBridge.bridge$getBlockCreatorUUID(blockPos).ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
            chunkBridge.bridge$getBlockNotifierUUID(blockPos).ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
        }
        frame.pushCause((Object)damageSource);
    }

    public static List<DamageFunction> createAttackEnchantmentFunction(class_1799 weapon, class_1297 entity, class_1282 damageSource) {
        class_9304 enchantments = (class_9304)weapon.method_57825(class_9334.field_49633, (Object)class_9304.field_49385);
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(weapon);
        return enchantments.method_57539().stream().map(entry -> {
            class_1887 enchantment = (class_1887)((class_6880)entry.getKey()).comp_349();
            int level = entry.getIntValue();
            DamageModifier modifier = DamageEventUtil.buildAttackEnchantmentModifier((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.WEAPON_ENCHANTMENT, snapshot, enchantment);
            return new DamageFunction(modifier, damage -> DamageEventUtil.enchantmentDamageFunction(weapon, entity, damageSource, damage, enchantment, level));
        }).toList();
    }

    public static DamageFunction provideSeparateEnchantmentFromBaseDamageFunction(float baseDamage, class_1799 weapon) {
        DamageModifier modifier = DamageEventUtil.buildAttackEnchantmentModifier((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.WEAPON_ENCHANTMENT, ItemStackUtil.snapshotOf(weapon));
        return new DamageFunction(modifier, damage -> damage - (double)baseDamage);
    }

    public static DamageFunction provideCooldownEnchantmentStrengthFunction(class_1799 weapon, float attackStrength) {
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(weapon);
        DamageModifier modifier = DamageEventUtil.buildAttackEnchantmentModifier((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.ATTACK_STRENGTH, snapshot);
        return new DamageFunction(modifier, damage -> damage * (double)attackStrength);
    }

    private static double enchantmentDamageFunction(class_1799 weapon, class_1297 entity, class_1282 damageSource, double damage, class_1887 enchantment, int level) {
        MutableFloat totalDamage = new MutableFloat((Number)damage);
        enchantment.method_60041((class_3218)entity.method_37908(), level, weapon, entity, damageSource, totalDamage);
        return totalDamage.doubleValue();
    }

    public static DamageFunction provideCriticalAttackFunction(class_1657 player, double criticalModifier) {
        DamageModifier modifier = DamageEventUtil.buildAttackDamageModifier((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.CRITICAL_HIT, player);
        DoubleUnaryOperator function = damage -> damage * criticalModifier;
        return new DamageFunction(modifier, function);
    }

    public static DamageFunction provideCooldownAttackStrengthFunction(class_1657 player, float attackStrength) {
        DamageModifier modifier = DamageEventUtil.buildAttackDamageModifier((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.ATTACK_COOLDOWN, player);
        DoubleUnaryOperator function = damage -> damage * (double)(0.2f + attackStrength * attackStrength * 0.8f);
        return new DamageFunction(modifier, function);
    }

    public static DamageFunction provideWeaponAttackDamageBonusFunction(class_1297 targetEntity, class_1799 weapon, class_1282 damageSource) {
        DamageModifier modifier = DamageEventUtil.buildAttackDamageModifier((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.WEAPON_BONUS, targetEntity);
        DoubleUnaryOperator function = damage -> damage + (double)weapon.method_7909().method_58403(targetEntity, (float)damage, damageSource);
        return new DamageFunction(modifier, function);
    }

    public static DamageFunction provideSweepingDamageRatioFunction(class_1799 held, class_1657 player, double attackDamage) {
        DamageModifier modifier = DamageEventUtil.buildAttackEnchantmentModifier((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.SWEEPING, ItemStackUtil.snapshotOf(held));
        return DamageFunction.of((DamageModifier)modifier, damage -> damage + player.method_45325(class_5134.field_51577) * attackDamage);
    }

    public static DamageFunction createShieldFunction(class_1309 entity) {
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(entity.method_6030());
        DamageModifier modifier = DamageEventUtil.buildDamageReductionModifier((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.SHIELD, entity, snapshot);
        return new DamageFunction(modifier, damage -> 0.0);
    }

    public static DamageFunction createFreezingBonus(class_1309 entity, class_1282 damageSource, float multiplier) {
        DamageModifier modifier = DamageEventUtil.buildDamageReductionModifier((DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.FREEZING_BONUS, damageSource, entity);
        return new DamageFunction(modifier, damage -> damage * (double)multiplier);
    }

    private static DamageModifier buildDamageReductionModifierWithFrame(DefaultedRegistryReference<DamageModifierType> modifierType, Object ... causes) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            for (Object cause : causes) {
                frame.pushCause(cause);
            }
            DamageModifier damageModifier = DamageModifier.builder().damageReductionGroup().cause(frame.currentCause()).type(modifierType).build();
            return damageModifier;
        }
    }

    private static DamageModifier buildAttackDamageModifier(DefaultedRegistryReference<DamageModifierType> modifierType, Object ... causes) {
        return DamageModifier.builder().attackDamageGroup().cause(Cause.of((EventContext)EventContext.empty(), Arrays.asList(causes))).type(modifierType).build();
    }

    private static DamageModifier buildAttackEnchantmentModifier(DefaultedRegistryReference<DamageModifierType> modifierType, Object ... causes) {
        return DamageModifier.builder().attackEnchantmentGroup().cause(Cause.of((EventContext)EventContext.empty(), Arrays.asList(causes))).type(modifierType).build();
    }

    private static DamageModifier buildDamageReductionModifier(DefaultedRegistryReference<DamageModifierType> modifierType, Object ... causes) {
        return DamageModifier.builder().damageReductionGroup().cause(Cause.of((EventContext)EventContext.empty(), Arrays.asList(causes))).type(modifierType).build();
    }

    public static AttackEntityEvent callPlayerAttackEntityEvent(Attack<class_1657> attack, float knockbackModifier) {
        boolean isMainthread;
        boolean bl = isMainthread = !attack.sourceEntity().method_37908().field_9236;
        if (isMainthread) {
            PhaseTracker.getInstance().pushCause(attack.dmgSource());
        }
        Cause currentCause = isMainthread ? PhaseTracker.getInstance().currentCause() : Cause.of((EventContext)EventContext.empty(), (Object)attack.dmgSource());
        AttackEntityEvent event = attack.postEvent(knockbackModifier, currentCause);
        if (isMainthread) {
            PhaseTracker.getInstance().popCause();
        }
        return event;
    }

    public static AttackEntityEvent callMobAttackEvent(Attack<class_1308> attack, float knockbackModifier) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.pushCause((Object)attack.dmgSource());
            AttackEntityEvent attackEntityEvent = attack.postEvent(knockbackModifier, frame.currentCause());
            return attackEntityEvent;
        }
    }

    public static AttackEntityEvent callOtherAttackEvent(class_1297 targetEntity, class_1282 damageSource, double damage) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            frame.pushCause((Object)damageSource);
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent((Cause)frame.currentCause(), (Entity)((Entity)targetEntity), new ArrayList(), (float)0.0f, (double)damage);
            SpongeCommon.post((Event)event);
            AttackEntityEvent attackEntityEvent = event;
            return attackEntityEvent;
        }
    }

    public static DamageEventResult callLivingDamageEntityEvent(Hurt hurt, ActuallyHurt actuallyHurt) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            DamageEventUtil.generateCauseFor(actuallyHurt.dmgSource(), frame);
            ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
            originalFunctions.addAll(hurt.functions());
            originalFunctions.addAll(actuallyHurt.functions());
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent((Cause)frame.currentCause(), (Entity)((Entity)actuallyHurt.entity()), originalFunctions, (double)actuallyHurt.baseDamage());
            if (actuallyHurt.dmgSource() != SpongeDamageSources.IGNORED) {
                SpongeCommon.post((Event)event);
            }
            DamageEventResult damageEventResult = new DamageEventResult(event, actuallyHurt.dmgSource(), DamageEventUtil.findDamageBefore(event, (DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.SHIELD), DamageEventUtil.findDamageDifference(event, (DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.SHIELD), DamageEventUtil.findDamageBefore(event, (DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.HARD_HAT), DamageEventUtil.findDamageBefore(event, (DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.ARMOR), DamageEventUtil.findDamageDifference(event, (DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.DEFENSIVE_POTION_EFFECT), DamageEventUtil.findDamageDifference(event, (DefaultedRegistryReference<DamageModifierType>)DamageModifierTypes.ABSORPTION));
            return damageEventResult;
        }
    }

    private static Optional<Float> findDamageDifference(DamageEntityEvent event, DefaultedRegistryReference<DamageModifierType> type) {
        return DamageEventUtil.findModifier(event, type).map(arg_0 -> ((DamageEntityEvent)event).damage(arg_0)).map(tuple -> (Double)tuple.first() - (Double)tuple.second()).map(Double::floatValue);
    }

    private static Optional<Float> findDamageBefore(DamageEntityEvent event, DefaultedRegistryReference<DamageModifierType> type) {
        return DamageEventUtil.findModifier(event, type).map(arg_0 -> ((DamageEntityEvent)event).damage(arg_0)).map(Tuple::first).map(Double::floatValue);
    }

    private static Optional<DamageModifier> findModifier(DamageEntityEvent event, DefaultedRegistryReference<DamageModifierType> type) {
        return event.originalFunctions().stream().map(DamageFunction::modifier).filter(mod -> ((DamageModifierType)type.get()).equals((Object)mod.type())).findFirst();
    }

    public static DamageEntityEvent callSimpleDamageEntityEvent(class_1282 source, class_1297 targetEntity, double amount) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            DamageEventUtil.generateCauseFor(source, frame);
            DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent((Cause)frame.currentCause(), (Entity)((Entity)targetEntity), new ArrayList(), (double)amount);
            SpongeCommon.post((Event)event);
            DamageEntityEvent damageEntityEvent = event;
            return damageEntityEvent;
        }
    }

    public record Attack<T>(T sourceEntity, class_1297 target, class_1799 weapon, class_1282 dmgSource, float strengthScale, float baseDamage, List<DamageFunction> functions) {
        private AttackEntityEvent postEvent(float knockbackModifier, Cause cause) {
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent((Cause)cause, (Entity)((Entity)this.target), this.functions, (float)knockbackModifier, (double)this.baseDamage);
            SpongeCommon.post((Event)event);
            return event;
        }
    }

    public record ActuallyHurt(class_1309 entity, List<DamageFunction> functions, class_1282 dmgSource, float baseDamage) {
    }

    public record Hurt(class_1282 dmgSource, List<DamageFunction> functions) {
    }

    public record DamageEventResult(DamageEntityEvent event, class_1282 source, Optional<Float> damageToShield, Optional<Float> damageBlockedByShield, Optional<Float> damageToHelmet, Optional<Float> damageToArmor, Optional<Float> damageResisted, Optional<Float> damageAbsorbed) {
    }
}

