/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import net.minecraft.class_1657;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;

public final class ExperienceHolderUtil {
    public static final int XP_AT_LEVEL_30 = ExperienceHolderUtil.xpAtLevel(30);
    public static final int XP_AT_LEVEL_15 = ExperienceHolderUtil.xpAtLevel(15);

    public static int getExpBetweenLevels(int level) {
        return level >= 30 ? 112 + (level - 30) * 9 : (level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2);
    }

    public static int xpAtLevel(int level) {
        if (level > 30) {
            return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        }
        if (level > 15) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return level * level + 6 * level;
    }

    public static int getLevelForExp(int experience) {
        if (experience >= XP_AT_LEVEL_30) {
            return (int)((162.5 + Math.sqrt(-13553.75 + (double)(18 * experience))) / 9.0);
        }
        if (experience >= XP_AT_LEVEL_15) {
            return (int)((40.5 + Math.sqrt(-1959.75 + (double)(10 * experience))) / 5.0);
        }
        return (int)(-3.0 + Math.sqrt(9 + experience));
    }

    public static void setExperience(class_1657 holder, Integer value) {
        int experienceForCurrentLevel;
        int level = -1;
        int experienceAtNextLevel = -1;
        do {
            experienceForCurrentLevel = experienceAtNextLevel;
        } while ((experienceAtNextLevel += ExperienceHolderUtil.getExpBetweenLevels(++level)) <= value && experienceAtNextLevel > 0);
        if (value == 0) {
            experienceForCurrentLevel = Math.max(0, experienceForCurrentLevel);
        }
        holder.field_7510 = (float)(value - experienceForCurrentLevel) / (float)ExperienceHolderUtil.getExpBetweenLevels(level);
        holder.field_7520 = level;
        holder.field_7495 = value;
        if (holder instanceof ServerPlayerBridge) {
            ((ServerPlayerBridge)holder).bridge$refreshExp();
        }
    }

    public static void setExperienceSinceLevel(class_1657 holder, Integer value) {
        while (value >= holder.method_7349()) {
            value = value - holder.method_7349();
        }
        ((PlayerBridge)holder).bridge$setExperienceSinceLevel(value);
        if (holder instanceof ServerPlayerBridge) {
            ((ServerPlayerBridge)holder).bridge$refreshExp();
        }
    }

    private ExperienceHolderUtil() {
    }
}

