/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.spongepowered.common.SpongeCommon;

public final class FileUtil {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-hhmmss").withZone(ZoneId.systemDefault());

    public static void copyCorruptedFile(Path path) {
        Path corruptPath = path.resolveSibling(path.getFileName().toString() + ".corrupted_" + FORMATTER.format(Instant.now()));
        try {
            Files.copy(path, corruptPath, new CopyOption[0]);
            SpongeCommon.logger().info("Copied corrupted file {} to {}.", (Object)path.toAbsolutePath().toString(), (Object)corruptPath.toAbsolutePath().toString());
        }
        catch (IOException exception) {
            SpongeCommon.logger().error("Failed to copy corrupted file {} to {}.", (Object)path.toAbsolutePath().toString(), (Object)corruptPath.toAbsolutePath().toString(), (Object)exception);
        }
    }

    private FileUtil() {
    }
}

