/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1671;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.accessor.world.entity.projectile.FireworkRocketEntityAccessor;
import org.spongepowered.common.item.SpongeItemStack;
import org.spongepowered.common.util.Preconditions;

public final class FireworkUtil {
    public static boolean setFireworkEffects(class_1671 firework, List<? extends FireworkEffect> effects) {
        return FireworkUtil.updateFireworkRocketItem(firework, item -> FireworkUtil.setFireworkEffects(item, effects));
    }

    public static boolean setFireworkEffects(class_1799 item, List<? extends FireworkEffect> effects) {
        if (effects.isEmpty()) {
            return FireworkUtil.removeFireworkEffects(item);
        }
        if (item.method_7960()) {
            return false;
        }
        if (item.method_7909() == class_1802.field_8450) {
            item.method_57379(class_9334.field_49615, (Object)((class_9283)effects.getFirst()));
            return true;
        }
        if (item.method_7909() == class_1802.field_8639) {
            List<class_9283> mcEffects = effects.stream().map(class_9283.class::cast).toList();
            item.method_57368(class_9334.field_49616, (Object)new class_9284(1, Collections.emptyList()), p -> new class_9284(p.comp_2391(), mcEffects));
            return true;
        }
        return false;
    }

    public static Optional<List<FireworkEffect>> getFireworkEffects(class_1671 firework) {
        return FireworkUtil.getFireworkEffects(FireworkUtil.getItem(firework));
    }

    public static Optional<List<FireworkEffect>> getFireworkEffects(class_1799 item) {
        if (item.method_7960()) {
            return Optional.empty();
        }
        if (item.method_7909() == class_1802.field_8639) {
            class_9284 fireworks = (class_9284)item.method_57824(class_9334.field_49616);
            if (fireworks == null || fireworks.comp_2392().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(fireworks.comp_2392().stream().map(FireworkEffect.class::cast).toList());
        }
        Preconditions.checkArgument(item.method_7909() == class_1802.field_8450, "Item is not a firework star!");
        class_9283 fireworkExplosion = (class_9283)item.method_57824(class_9334.field_49615);
        if (fireworkExplosion == null) {
            return Optional.empty();
        }
        return Optional.of(List.of((FireworkEffect)fireworkExplosion));
    }

    public static boolean removeFireworkEffects(class_1671 firework) {
        return FireworkUtil.updateFireworkRocketItem(firework, FireworkUtil::removeFireworkEffects);
    }

    public static boolean removeFireworkEffects(class_1799 item) {
        if (item.method_7960()) {
            return false;
        }
        if (item.method_7909() == class_1802.field_8450) {
            item.method_57381(class_9334.field_49615);
            return true;
        }
        if (item.method_7909() == class_1802.field_8639) {
            if (item.method_57826(class_9334.field_49616)) {
                item.method_57368(class_9334.field_49616, null, p -> new class_9284(p.comp_2391(), Collections.emptyList()));
            }
            return true;
        }
        return false;
    }

    public static boolean setFlightModifier(class_1671 firework, int modifier) {
        int lifetime = 10 * modifier + ((EntityAccessor)firework).accessor$random().method_43048(6) + ((EntityAccessor)firework).accessor$random().method_43048(7);
        ((FireworkRocketEntityAccessor)firework).accessor$lifetime(lifetime);
        return true;
    }

    public static boolean setFlightModifier(class_1799 item, int modifier) {
        if (item.method_7960()) {
            return false;
        }
        if (item.method_7909() == class_1802.field_8639) {
            item.method_57368(class_9334.field_49616, (Object)new class_9284(1, Collections.emptyList()), p -> new class_9284(modifier, p.comp_2392()));
            return true;
        }
        return false;
    }

    public static OptionalInt getFlightModifier(class_1671 firework) {
        return FireworkUtil.getFlightModifier(FireworkUtil.getItem(firework));
    }

    public static OptionalInt getFlightModifier(class_1799 item) {
        class_9284 fireworks = (class_9284)item.method_57824(class_9334.field_49616);
        if (fireworks == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(fireworks.comp_2391());
    }

    public static boolean updateFireworkRocketItem(class_1671 firework, Function<class_1799, Boolean> function) {
        class_1799 item = FireworkUtil.getItem(firework).method_7972();
        if (function.apply(item).booleanValue()) {
            firework.method_5841().method_12778(FireworkRocketEntityAccessor.accessor$DATA_ID_FIREWORKS_ITEM(), (Object)item);
            return true;
        }
        return false;
    }

    public static class_1799 getItem(class_1671 firework) {
        class_1799 item = (class_1799)firework.method_5841().method_12789(FireworkRocketEntityAccessor.accessor$DATA_ID_FIREWORKS_ITEM());
        if (item.method_7960()) {
            return (class_1799)new SpongeItemStack.BuilderImpl().itemType((Supplier)ItemTypes.FIREWORK_ROCKET).build();
        }
        return item;
    }

    private FireworkUtil() {
    }
}

