/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.management.MBeanServer;
import org.spongepowered.common.SpongeCommon;

public final class JvmUtil {
    public static boolean dumpHeap() {
        Path p = Path.of(".", "dumps", "heap-dump-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + "-server.hprof");
        SpongeCommon.logger().info("Writing JVM heap data to: {}", (Object)p.toAbsolutePath());
        try {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Object hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", clazz);
            Method m = clazz.getMethod("dumpHeap", String.class, Boolean.TYPE);
            m.invoke(hotspotMBean, p.toString(), true);
            SpongeCommon.logger().info("Heap dump complete");
            return true;
        }
        catch (Throwable t) {
            SpongeCommon.logger().error((Object)t);
            SpongeCommon.logger().error(MessageFormat.format("Could not write heap to {0}: {1}", p, t.getMessage()));
            return false;
        }
    }
}

