/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import io.netty.channel.local.LocalAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class NetworkUtil {
    public static final String LOCAL_ADDRESS = "local";

    public static String getHostString(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)address;
            return isa.getHostString();
        }
        if (address instanceof LocalAddress) {
            return LOCAL_ADDRESS;
        }
        return address.toString();
    }

    public static String cleanVirtualHost(String host) {
        if ((host = NetworkUtil.substringBefore(host, '\u0000')).endsWith(".")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    public static String substringBefore(String s, char c) {
        int pos = s.indexOf(c);
        return pos >= 0 ? s.substring(0, pos) : s;
    }

    private NetworkUtil() {
    }
}

