/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_175;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.OperatorCriterion;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.advancement.criterion.DefaultedAdvancementCriterion;
import org.spongepowered.common.advancement.criterion.SpongeAndCriterion;
import org.spongepowered.common.advancement.criterion.SpongeEmptyCriterion;
import org.spongepowered.common.advancement.criterion.SpongeOperatorCriterion;
import org.spongepowered.common.advancement.criterion.SpongeOrCriterion;
import org.spongepowered.common.advancement.criterion.SpongeScoreCriterion;

public final class SpongeCriterionUtil {
    public static AdvancementCriterion build(Class<? extends OperatorCriterion> type, Function<Set<AdvancementCriterion>, AdvancementCriterion> function, AdvancementCriterion criterion, Iterable<AdvancementCriterion> criteria) {
        Objects.requireNonNull(criteria, "criteria");
        ArrayList<AdvancementCriterion> builder = new ArrayList<AdvancementCriterion>();
        SpongeCriterionUtil.build(type, criterion, builder);
        for (AdvancementCriterion criterion1 : criteria) {
            SpongeCriterionUtil.build(type, criterion1, builder);
        }
        return builder.isEmpty() ? new SpongeEmptyCriterion() : (builder.size() == 1 ? (AdvancementCriterion)builder.get(0) : function.apply((Set<AdvancementCriterion>)ImmutableSet.copyOf(builder)));
    }

    private static void build(Class<? extends OperatorCriterion> type, AdvancementCriterion criterion, List<AdvancementCriterion> criteria) {
        if (criterion instanceof SpongeEmptyCriterion) {
            return;
        }
        Objects.requireNonNull(criterion, "criterion");
        if (type.isInstance(criterion)) {
            criteria.addAll(((OperatorCriterion)criterion).criteria());
        } else {
            criteria.add(criterion);
        }
    }

    public static Tuple<Map<String, class_175<?>>, List<List<String>>> toVanillaCriteriaData(AdvancementCriterion criterion) {
        LinkedHashMap criteria = new LinkedHashMap();
        if (criterion instanceof SpongeEmptyCriterion) {
            return new Tuple(criteria, Collections.emptyList());
        }
        return new Tuple(criteria, SpongeCriterionUtil.collectCriteria(criterion, criteria));
    }

    private static List<List<String>> collectCriteria(AdvancementCriterion criterion, Map<String, class_175<?>> criteria) {
        ArrayList<List<String>> requirements = new ArrayList<List<String>>();
        if (criterion instanceof SpongeAndCriterion) {
            ((SpongeOperatorCriterion)criterion).criteria().forEach(c -> requirements.addAll(SpongeCriterionUtil.collectCriteria(c, criteria)));
        } else if (criterion instanceof SpongeOrCriterion) {
            List<List> andRequirementsList = ((SpongeOperatorCriterion)criterion).criteria().stream().map(c -> SpongeCriterionUtil.collectCriteria(c, criteria)).toList();
            ArrayList finalList = new ArrayList();
            for (List andRequirements : andRequirementsList) {
                if (finalList.isEmpty()) {
                    finalList.addAll(andRequirements);
                    continue;
                }
                ArrayList workingList = new ArrayList();
                for (List andRequirement : andRequirements) {
                    for (List prevAndRequirement : finalList) {
                        ArrayList newAndRequirement = new ArrayList(prevAndRequirement);
                        newAndRequirement.addAll(andRequirement);
                        workingList.add(newAndRequirement);
                    }
                }
                finalList = workingList;
            }
            requirements.addAll(finalList);
        } else if (criterion instanceof SpongeScoreCriterion) {
            SpongeScoreCriterion scoreCriterion = (SpongeScoreCriterion)criterion;
            for (int i = 0; i < scoreCriterion.goal(); ++i) {
                DefaultedAdvancementCriterion internalCriterion = scoreCriterion.internalCriteria.get(i);
                criteria.put(internalCriterion.name(), (class_175)internalCriterion);
                requirements.add(Collections.singletonList(internalCriterion.name()));
            }
        } else {
            criteria.put(criterion.name(), (class_175)criterion);
            requirements.add(Collections.singletonList(criterion.name()));
        }
        return requirements;
    }

    private SpongeCriterionUtil() {
    }
}

