/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.time.Duration;
import java.util.Objects;
import org.spongepowered.api.Engine;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.util.Preconditions;

public final class SpongeMinecraftDayTime
implements MinecraftDayTime {
    private final long internalTime;
    private final long internalTimeWithOffset;

    static long getTicksFor(long days, long hours, long minutes) {
        return (long)((double)(days * 24000L + hours * 1000L) + (double)minutes * 16.666666666666668);
    }

    public SpongeMinecraftDayTime(long internalTime) {
        if (internalTime < 0L) {
            throw new IllegalArgumentException("Internal time cannot be negative!");
        }
        this.internalTime = internalTime;
        this.internalTimeWithOffset = internalTime + 6000L;
    }

    public int day() {
        return (int)(this.internalTimeWithOffset / 24000L) + 1;
    }

    public int hour() {
        return (int)(this.internalTimeWithOffset % 24000L / 1000L);
    }

    public int minute() {
        return (int)((double)(this.internalTimeWithOffset % 1000L) / 16.666666666666668);
    }

    public MinecraftDayTime add(Ticks ticks) {
        Objects.requireNonNull(ticks);
        if (ticks.isInfinite()) {
            throw new IllegalArgumentException("Ticks cannot be infinite!");
        }
        return new SpongeMinecraftDayTime(this.internalTime + ticks.ticks());
    }

    public MinecraftDayTime add(int days, int hours, int minutes) {
        if (days < 0) {
            throw new IllegalArgumentException("Days cannot be negative!");
        }
        if (hours < 0 || hours > 23) {
            throw new IllegalArgumentException("Hours is not between 0 and 23!");
        }
        if (minutes < 0 || minutes > 59) {
            throw new IllegalArgumentException("Minutes is not between 0 and 59!");
        }
        return new SpongeMinecraftDayTime(this.internalTime + SpongeMinecraftDayTime.getTicksFor(days, hours, minutes));
    }

    public MinecraftDayTime subtract(Ticks ticks) {
        Objects.requireNonNull(ticks);
        if (ticks.isInfinite()) {
            throw new IllegalArgumentException("Ticks cannot be infinite!");
        }
        long time = this.internalTime - ticks.ticks();
        if (time <= 0L) {
            throw new IllegalArgumentException("ticks is larger than this day time object");
        }
        return new SpongeMinecraftDayTime(this.internalTime - ticks.ticks());
    }

    public MinecraftDayTime subtract(int days, int hours, int minutes) {
        Preconditions.checkArgument(days >= 0, "days is negative");
        Preconditions.checkArgument(hours >= 0 && hours <= 23, "hours is not between 0 and 23");
        Preconditions.checkArgument(minutes >= 0 && minutes <= 59, "minutes is not between 0 and 59");
        long newTickTime = this.internalTime - SpongeMinecraftDayTime.getTicksFor(days, hours, minutes);
        if (newTickTime < 0L) {
            throw new IllegalArgumentException("The result MinecraftDayTime would be negative.");
        }
        return new SpongeMinecraftDayTime(newTickTime);
    }

    public Duration asInGameDuration() {
        return Duration.ofMinutes((long)this.day() * 24L * 60L + (long)this.hour() * 60L + (long)this.minute());
    }

    public Ticks asTicks() {
        return Ticks.of((long)this.internalTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeMinecraftDayTime that = (SpongeMinecraftDayTime)o;
        return this.internalTime == that.internalTime;
    }

    public int hashCode() {
        return Objects.hash(this.internalTime);
    }

    public static final class Factory
    implements MinecraftDayTime.Factory {
        private final MinecraftDayTime epoch = new SpongeMinecraftDayTime(0L);

        public MinecraftDayTime epoch() {
            return this.epoch;
        }

        public MinecraftDayTime of(Engine engine, Duration duration) {
            Objects.requireNonNull(engine);
            Objects.requireNonNull(duration);
            if (!duration.isNegative()) {
                throw new IllegalArgumentException("Duration is negative!");
            }
            return new SpongeMinecraftDayTime((long)((double)duration.toMinutes() * 16.666666666666668));
        }

        public MinecraftDayTime of(int days, int hours, int minutes) {
            if (days < 1) {
                throw new IllegalArgumentException("Days must be greater than 0!");
            }
            if (hours < 0 || hours > 23 || days == 1 && hours < 6) {
                throw new IllegalArgumentException("Hours is not between 0 and 23 (or 6 and 23 for day 1)!");
            }
            if (minutes < 0 || minutes > 59) {
                throw new IllegalArgumentException("Minutes is not between 0 and 59!");
            }
            return new SpongeMinecraftDayTime(SpongeMinecraftDayTime.getTicksFor(days, hours, minutes) - 6000L);
        }

        public MinecraftDayTime of(Engine engine, Ticks ticks) {
            Objects.requireNonNull(engine);
            Objects.requireNonNull(ticks);
            if (ticks.isInfinite()) {
                throw new IllegalArgumentException("Ticks cannot be infinite!");
            }
            return new SpongeMinecraftDayTime(ticks.ticks());
        }
    }
}

