/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.Objects;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.util.Transform;
import org.spongepowered.math.imaginary.Quaterniond;
import org.spongepowered.math.matrix.Matrix4d;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector4d;

public final class SpongeTransform
implements Transform {
    private final Vector3d position;
    private final Vector3d rotation;
    private final Vector3d scale;
    private @Nullable Quaterniond rotationQuaternion = null;

    public SpongeTransform(Vector3d position, Vector3d rotation, Vector3d scale) {
        this.position = position;
        this.rotation = rotation;
        this.scale = scale;
    }

    public Vector3d position() {
        return this.position;
    }

    public Transform withPosition(Vector3d position) {
        Objects.requireNonNull(position);
        return new SpongeTransform(position, this.rotation, this.scale);
    }

    public Vector3d rotation() {
        return this.rotation;
    }

    public Transform withRotation(Vector3d rotation) {
        Objects.requireNonNull(rotation);
        return new SpongeTransform(this.position, rotation, this.scale);
    }

    public Transform withRotation(Quaterniond rotation) {
        Objects.requireNonNull(rotation);
        return this.withRotation(SpongeTransform.toAxesAngles(rotation));
    }

    public Quaterniond rotationAsQuaternion() {
        if (this.rotationQuaternion == null) {
            this.rotationQuaternion = SpongeTransform.fromAxesAngles(this.rotation);
        }
        return this.rotationQuaternion;
    }

    public double pitch() {
        return this.rotation.x();
    }

    public double yaw() {
        return this.rotation.y();
    }

    public double roll() {
        return this.rotation.z();
    }

    public Vector3d scale() {
        return this.scale;
    }

    public Transform withScale(Vector3d scale) {
        Objects.requireNonNull(scale);
        return new SpongeTransform(this.position, this.rotation, scale);
    }

    public Transform add(Transform other) {
        Objects.requireNonNull(other);
        return new SpongeTransform(this.position.add(other.position()), SpongeTransform.toAxesAngles(this.rotationAsQuaternion().mul(other.rotationAsQuaternion())), this.scale.add(other.scale()));
    }

    public Transform translate(Vector3d translation) {
        Objects.requireNonNull(translation);
        return new SpongeTransform(this.position.add(translation), this.rotation, this.scale);
    }

    public Transform rotate(Vector3d rotation) {
        Objects.requireNonNull(rotation);
        return this.rotate(SpongeTransform.fromAxesAngles(rotation));
    }

    public Transform rotate(Quaterniond rotation) {
        Objects.requireNonNull(rotation);
        return new SpongeTransform(this.position, SpongeTransform.toAxesAngles(this.rotationAsQuaternion().mul(rotation)), this.scale);
    }

    public Transform scale(Vector3d scale) {
        Objects.requireNonNull(scale);
        return new SpongeTransform(this.position, this.rotation, this.scale.mul(scale));
    }

    public Matrix4d toMatrix() {
        return Matrix4d.createScaling((Vector4d)this.scale.toVector4(1.0f)).rotate(this.rotationAsQuaternion()).translate(this.position);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SpongeTransform)) {
            return false;
        }
        SpongeTransform that = (SpongeTransform)obj;
        return Objects.equals(this.position, that.position) && Objects.equals(this.rotation, that.rotation) && Objects.equals(this.scale, that.scale);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.rotation, this.scale);
    }

    public String toString() {
        return new StringJoiner(", ", SpongeTransform.class.getSimpleName() + "[", "]").add("position=" + String.valueOf(this.position)).add("rotation=" + String.valueOf(this.rotation)).add("scale=" + String.valueOf(this.scale)).toString();
    }

    private static Vector3d toAxesAngles(Quaterniond quaternion) {
        Vector3d axesAngles = quaternion.axesAnglesDeg();
        return new Vector3d(axesAngles.x(), -axesAngles.y(), axesAngles.z());
    }

    private static Quaterniond fromAxesAngles(Vector3d angles) {
        return Quaterniond.fromAxesAnglesDeg((double)angles.x(), (double)(-angles.y()), (double)angles.z());
    }

    public static final class Factory
    implements Transform.Factory {
        public Transform create(Vector3d position, Vector3d rotation, Vector3d scale) {
            Objects.requireNonNull(position);
            Objects.requireNonNull(rotation);
            Objects.requireNonNull(scale);
            return new SpongeTransform(position, rotation, scale);
        }
    }
}

