/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.raytrace;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.blockray.RayTraceResult;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.util.raytrace.AbstractSpongeRayTrace;
import org.spongepowered.common.util.raytrace.SpongeRayTraceResult;

public final class SpongeEntityRayTrace
extends AbstractSpongeRayTrace<Entity> {
    private static final Predicate<Entity> DEFAULT_FILTER = entity -> true;

    public SpongeEntityRayTrace() {
        super(DEFAULT_FILTER);
    }

    @Override
    boolean requiresEntityTracking() {
        return true;
    }

    @Override
    List<class_1297> selectEntities(ServerWorld serverWorld, class_238 targetAABB) {
        return ((class_1937)serverWorld).method_8333((class_1297)null, targetAABB, this.select);
    }

    @Override
    final Optional<RayTraceResult<@NonNull Entity>> testSelectLocation(ServerWorld serverWorld, class_243 vec3din, class_243 vec3dend) {
        double currentSqDist = Double.MAX_VALUE;
        SpongeRayTraceResult<Entity> returnedEntity = null;
        LocatableBlock locatableBlock = this.getBlock(serverWorld, vec3din, vec3dend);
        for (class_1297 entity : this.selectEntities(serverWorld, this.getBlockAABB(locatableBlock.blockPosition()))) {
            class_243 hitPosition;
            double sqdist;
            Optional vec3d = entity.method_5829().method_992(vec3din, vec3dend);
            if (!vec3d.isPresent() || !((sqdist = (hitPosition = (class_243)vec3d.get()).method_1025(vec3din)) < currentSqDist)) continue;
            currentSqDist = sqdist;
            returnedEntity = new SpongeRayTraceResult<Entity>((Entity)entity, VecHelper.toVector3d(hitPosition));
        }
        return Optional.ofNullable(returnedEntity);
    }

    @Override
    final boolean shouldCheckFailures() {
        return true;
    }
}

