/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.transformation;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.util.rotation.Rotation;
import org.spongepowered.api.util.rotation.Rotations;
import org.spongepowered.api.util.transformation.Transformation;
import org.spongepowered.common.util.transformation.SpongeTransformationBuilder;
import org.spongepowered.math.GenericMath;
import org.spongepowered.math.matrix.Matrix4d;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector4d;

public final class SpongeTransformation
implements Transformation {
    final Vector3d origin;
    final Matrix4d transformation;
    final Matrix4d directionTransformation;
    final boolean performRounding;
    final Rotation rotation;
    final boolean flipx;
    final boolean flipz;

    public SpongeTransformation(Vector3d origin, Matrix4d transformation, Matrix4d directionTransformation, boolean performRounding, Rotation rotation, boolean flipx, boolean flipz) {
        this.origin = origin;
        this.transformation = transformation;
        this.directionTransformation = directionTransformation;
        this.performRounding = performRounding;
        this.rotation = rotation;
        this.flipx = flipx;
        this.flipz = flipz;
    }

    public boolean performsRounding() {
        return this.performRounding;
    }

    public @NonNull Vector3d transformPosition(@NonNull Vector3d original) {
        Vector4d transformed = this.transformation.transform(original.toVector4(1.0f));
        if (this.performRounding) {
            return new Vector3d(GenericMath.round((double)transformed.x(), (int)14), GenericMath.round((double)transformed.y(), (int)14), GenericMath.round((double)transformed.z(), (int)14));
        }
        return transformed.toVector3();
    }

    public @NonNull Vector3d transformDirection(@NonNull Vector3d original) {
        Vector4d transformed = this.directionTransformation.transform(original.normalize().toVector4(1.0f));
        Vector3d result = this.performRounding ? new Vector3d(GenericMath.round((double)transformed.x(), (int)14), GenericMath.round((double)transformed.y(), (int)14), GenericMath.round((double)transformed.z(), (int)14)) : transformed.toVector3();
        return result.normalize();
    }

    public @NonNull Matrix4d positionTransformationMatrix() {
        return this.transformation;
    }

    public @NonNull Matrix4d directionTransformationMatrix() {
        return this.directionTransformation;
    }

    public @NonNull Vector3d origin() {
        return this.origin;
    }

    public @NonNull Rotation rotation() {
        return this.rotation;
    }

    public boolean mirror(@NonNull Axis axis) {
        if (Objects.requireNonNull(axis, "axis") == Axis.X) {
            return this.flipx;
        }
        if (axis == Axis.Z) {
            return this.flipz;
        }
        return false;
    }

    public boolean initialMirror(@NonNull Axis axis) {
        if (this.flipMirror(this.rotation)) {
            if (Objects.requireNonNull(axis, "axis") == Axis.X) {
                return this.flipz;
            }
            if (axis == Axis.Z) {
                return this.flipx;
            }
            return false;
        }
        return this.mirror(axis);
    }

    public @NonNull Transformation inverse() {
        boolean inverseFlipZ;
        boolean inverseFlipX;
        Rotation inverseRotation = this.rotation == Rotations.CLOCKWISE_90.get() ? (Rotation)Rotations.COUNTERCLOCKWISE_90.get() : (this.rotation == Rotations.COUNTERCLOCKWISE_90.get() ? (Rotation)Rotations.CLOCKWISE_90.get() : this.rotation);
        if (this.flipMirror(inverseRotation)) {
            inverseFlipX = this.flipz;
            inverseFlipZ = this.flipx;
        } else {
            inverseFlipX = this.flipx;
            inverseFlipZ = this.flipz;
        }
        return new SpongeTransformation(this.origin, this.transformation.invert(), this.directionTransformation.invert(), this.performRounding, inverseRotation, inverseFlipX, inverseFlipZ);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Transformation.Builder toBuilder() {
        return new SpongeTransformationBuilder(this);
    }

    public @NonNull Transformation then(@NonNull Transformation transformation) {
        Objects.requireNonNull(transformation, "transformation");
        if (!(transformation instanceof SpongeTransformation)) {
            throw new IllegalArgumentException("Transformation must be of type SpongeTransformation");
        }
        SpongeTransformation spongeTransformation = (SpongeTransformation)transformation;
        Rotation rotation = this.rotation.and(spongeTransformation.rotation);
        boolean flipMirror = this.flipMirror(rotation);
        return new SpongeTransformation(this.origin.equals((Object)((SpongeTransformation)transformation).origin) ? this.origin : Vector3d.ZERO, spongeTransformation.transformation.mul(this.transformation), spongeTransformation.directionTransformation.mul(this.directionTransformation), this.performRounding, rotation, this.flipx ^ flipMirror ^ spongeTransformation.flipx, this.flipz ^ flipMirror ^ spongeTransformation.flipz);
    }

    private boolean flipMirror(Rotation rotation) {
        if (this.flipz != this.flipx) {
            return rotation == Rotations.CLOCKWISE_90.get() || rotation == Rotations.COUNTERCLOCKWISE_90.get();
        }
        return false;
    }
}

