/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import java.util.StringJoiner;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;

public record SpongeBlockChangeFlag(int rawFlag) implements BlockChangeFlag
{
    public boolean updateNeighbors() {
        return (this.rawFlag & 1) != 0;
    }

    public boolean notifyClients() {
        return (this.rawFlag & 2) != 0;
    }

    public boolean performBlockPhysics() {
        return (this.rawFlag & Integer.MIN_VALUE) == 0;
    }

    public boolean updateNeighboringShapes() {
        return (this.rawFlag & 0x10) == 0;
    }

    public boolean updateLighting() {
        return (this.rawFlag & 0x80) == 0;
    }

    public boolean notifyPathfinding() {
        return (this.rawFlag & 0x40000000) == 0;
    }

    public boolean ignoreRender() {
        return (this.rawFlag & 4) != 0;
    }

    public boolean forceClientRerender() {
        return (this.rawFlag & 8) != 0;
    }

    public boolean movingBlocks() {
        return (this.rawFlag & 0x40) != 0;
    }

    public boolean neighborDropsAllowed() {
        return (this.rawFlag & 0x20) == 0;
    }

    public boolean performBlockDestruction() {
        return (this.rawFlag & 0x20000000) == 0;
    }

    public SpongeBlockChangeFlag withUpdateNeighbors(boolean updateNeighbors) {
        if (this.updateNeighbors() == updateNeighbors) {
            return this;
        }
        return BlockChangeFlagManager.fromNativeInt(updateNeighbors ? this.rawFlag | 1 : this.rawFlag & 0xFFFFFFFE);
    }

    public SpongeBlockChangeFlag withNotifyClients(boolean notifyClients) {
        if (this.notifyClients() == notifyClients) {
            return this;
        }
        return BlockChangeFlagManager.fromNativeInt(notifyClients ? this.rawFlag | 2 : this.rawFlag & 0xFFFFFFFD);
    }

    public SpongeBlockChangeFlag withPhysics(boolean performBlockPhysics) {
        if (this.performBlockPhysics() == performBlockPhysics) {
            return this;
        }
        return BlockChangeFlagManager.fromNativeInt(performBlockPhysics ? this.rawFlag & Integer.MAX_VALUE : this.rawFlag | Integer.MIN_VALUE);
    }

    public SpongeBlockChangeFlag withNotifyObservers(boolean notifyObservers) {
        if (this.updateNeighboringShapes() == notifyObservers) {
            return this;
        }
        return BlockChangeFlagManager.fromNativeInt(notifyObservers ? this.rawFlag & 0xFFFFFFEF : this.rawFlag | 0x10);
    }

    public SpongeBlockChangeFlag withLightingUpdates(boolean lighting) {
        if (this.updateLighting() == lighting) {
            return this;
        }
        return BlockChangeFlagManager.fromNativeInt(lighting ? this.rawFlag & 0xFFFFFF7F : this.rawFlag | 0x80);
    }

    public SpongeBlockChangeFlag withPathfindingUpdates(boolean pathfindingUpdates) {
        if (this.notifyPathfinding() == pathfindingUpdates) {
            return this;
        }
        return BlockChangeFlagManager.fromNativeInt(pathfindingUpdates ? this.rawFlag & 0xBFFFFFFF : this.rawFlag | 0x40000000);
    }

    public SpongeBlockChangeFlag withNeighborDropsAllowed(boolean dropsAllowed) {
        if (this.neighborDropsAllowed() == dropsAllowed) {
            return this;
        }
        return BlockChangeFlagManager.fromNativeInt(dropsAllowed ? this.rawFlag & 0xFFFFFFDF : this.rawFlag | 0x20);
    }

    public SpongeBlockChangeFlag withBlocksMoving(boolean moving) {
        if (this.movingBlocks() == moving) {
            return this;
        }
        return BlockChangeFlagManager.fromNativeInt(moving ? this.rawFlag | 0x40 : this.rawFlag & 0xFFFFFFBF);
    }

    public SpongeBlockChangeFlag withIgnoreRender(boolean ignoreRender) {
        if (this.ignoreRender() == ignoreRender) {
            return this;
        }
        return BlockChangeFlagManager.fromNativeInt(ignoreRender ? this.rawFlag | 4 : this.rawFlag & 0xFFFFFFFB);
    }

    public SpongeBlockChangeFlag withForcedReRender(boolean forcedReRender) {
        if (this.forceClientRerender() == forcedReRender) {
            return this;
        }
        return BlockChangeFlagManager.fromNativeInt(forcedReRender ? this.rawFlag | 8 : this.rawFlag & 0xFFFFFFF7);
    }

    public SpongeBlockChangeFlag withPerformBlockDestruction(boolean performBlockDestruction) {
        if (this.performBlockDestruction() == performBlockDestruction) {
            return this;
        }
        return BlockChangeFlagManager.fromNativeInt(performBlockDestruction ? this.rawFlag & 0xDFFFFFFF : this.rawFlag | 0x20000000);
    }

    public SpongeBlockChangeFlag inverse() {
        return BlockChangeFlagManager.fromNativeInt(~this.rawFlag & 0xE00000FF);
    }

    public SpongeBlockChangeFlag andFlag(BlockChangeFlag flag) {
        SpongeBlockChangeFlag o = (SpongeBlockChangeFlag)flag;
        return BlockChangeFlagManager.fromNativeInt(this.rawFlag | o.rawFlag);
    }

    public SpongeBlockChangeFlag andNotFlag(BlockChangeFlag flag) {
        SpongeBlockChangeFlag o = (SpongeBlockChangeFlag)flag;
        return BlockChangeFlagManager.fromNativeInt(this.rawFlag & ~o.rawFlag);
    }

    public int getRawFlag() {
        return this.rawFlag;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", SpongeBlockChangeFlag.class.getSimpleName() + "[", "]").add("rawFlag=" + this.rawFlag).add("notifyNeighbors=" + this.updateNeighbors()).add("notifyClients=" + this.notifyClients()).add("performBlockPhysics=" + this.performBlockPhysics()).add("updateNeighboringShapes=" + this.updateNeighboringShapes()).add("updateLighting=" + this.updateLighting()).add("notifyPathfinding=" + this.notifyPathfinding()).add("ignoreRender=" + this.ignoreRender()).add("forceClientRerender=" + this.forceClientRerender()).add("movingBlocks=" + this.movingBlocks()).add("neighborDropsAllowed=" + this.neighborDropsAllowed()).add("performBlockDestruction=" + this.performBlockDestruction()).toString();
    }

    public SpongeBlockChangeFlag asNestedNeighborUpdates() {
        return BlockChangeFlagManager.fromNativeInt(this.rawFlag & 0xFFFFFFDE);
    }
}

