/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1927;
import net.minecraft.class_3218;
import net.minecraft.class_9892;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.explosion.ExplosionBlockInteraction;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.bridge.world.level.ExplosionBridge;
import org.spongepowered.common.util.Preconditions;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

public class SpongeExplosionBuilder
implements Explosion.Builder {
    private ServerLocation location;
    private @Nullable Explosive sourceExplosive;
    private float radius;
    private boolean canCauseFire;
    private class_1927.class_4179 blockInteraction;
    private boolean shouldSmoke;
    private boolean shouldDamageEntities = true;
    private int resolution = 16;
    private float randomness = 1.0f;
    private double knockback = 1.0;

    public SpongeExplosionBuilder() {
        this.reset();
    }

    public Explosion.Builder sourceExplosive(@Nullable Explosive source) {
        this.sourceExplosive = source;
        return this;
    }

    public Explosion.Builder radius(float radius) {
        this.radius = radius;
        return this;
    }

    public Explosion.Builder location(ServerLocation location) {
        this.location = Objects.requireNonNull(location, "location");
        return this;
    }

    public Explosion.Builder canCauseFire(boolean fire) {
        this.canCauseFire = fire;
        return this;
    }

    public Explosion.Builder shouldDamageEntities(boolean damage) {
        this.shouldDamageEntities = damage;
        return this;
    }

    public Explosion.Builder shouldPlaySmoke(boolean smoke) {
        this.shouldSmoke = smoke;
        return this;
    }

    public Explosion.Builder blockInteraction(ExplosionBlockInteraction interaction) {
        this.blockInteraction = (class_1927.class_4179)interaction;
        return this;
    }

    public Explosion.Builder resolution(int resolution) {
        this.resolution = Math.max(resolution, 2);
        return this;
    }

    public Explosion.Builder randomness(float randomness) {
        this.randomness = randomness;
        return this;
    }

    public Explosion.Builder knockback(double knockback) {
        this.knockback = knockback;
        return this;
    }

    public Explosion.Builder from(Explosion value) {
        this.location = value.serverLocation();
        this.sourceExplosive = value.sourceExplosive().orElse(null);
        this.radius = value.radius();
        this.canCauseFire = value.canCauseFire();
        this.blockInteraction = ((class_9892)value).method_55111();
        this.shouldSmoke = value.shouldPlaySmoke();
        this.shouldDamageEntities = value.shouldDamageEntities();
        this.resolution = value.resolution();
        this.randomness = value.randomness();
        this.knockback = value.knockback();
        return this;
    }

    public SpongeExplosionBuilder reset() {
        this.location = null;
        this.blockInteraction = null;
        this.sourceExplosive = null;
        this.radius = 0.0f;
        this.canCauseFire = false;
        this.shouldSmoke = false;
        this.shouldDamageEntities = true;
        this.resolution = 16;
        this.randomness = 1.0f;
        this.knockback = 1.0;
        return this;
    }

    public Explosion build() throws IllegalStateException {
        Preconditions.checkState(this.location != null, "Location is null!");
        World world = this.location.world();
        Vector3d origin = this.location.position();
        class_9892 explosion = new class_9892((class_3218)world, (class_1297)this.sourceExplosive, null, null, VecHelper.toVanillaVector3d(origin), this.radius, this.canCauseFire, this.blockInteraction);
        ((ExplosionBridge)explosion).bridge$setShouldDamageEntities(this.shouldDamageEntities);
        ((ExplosionBridge)explosion).bridge$setShouldPlaySmoke(this.shouldSmoke);
        ((ExplosionBridge)explosion).bridge$setResolution(this.resolution);
        ((ExplosionBridge)explosion).bridge$setRandomness(this.randomness);
        ((ExplosionBridge)explosion).bridge$setKnockback(this.knockback);
        return (Explosion)explosion;
    }
}

