/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1972;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6554;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.BiomeAttributes;
import org.spongepowered.common.accessor.world.level.biome.OverworldBiomeBuilderAccessor;

public final class SpongeBiomeAttributesFactory
implements BiomeAttributes.Factory {
    private final class_6544.class_6546 FULL_RANGE = class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f);
    private static Map<ResourceKey, BiomeAttributes> DEFAULT_ATTRIBUTES;

    public BiomeAttributes ofPoint(float temperature, float humidity, float continentalness, float erosion, float depth, float weirdness, float offset) {
        class_6544.class_6546 mcTemperature = class_6544.class_6546.method_38120((float)temperature);
        class_6544.class_6546 mcHumidity = class_6544.class_6546.method_38120((float)humidity);
        class_6544.class_6546 mcContinentalness = class_6544.class_6546.method_38120((float)continentalness);
        class_6544.class_6546 mcErosion = class_6544.class_6546.method_38120((float)erosion);
        class_6544.class_6546 mcDepth = class_6544.class_6546.method_38120((float)depth);
        class_6544.class_6546 mcWeirdness = class_6544.class_6546.method_38120((float)weirdness);
        long mcOffset = class_6544.method_38665((float)offset);
        return (BiomeAttributes)new class_6544.class_4762(mcTemperature, mcHumidity, mcContinentalness, mcErosion, mcDepth, mcWeirdness, mcOffset);
    }

    public BiomeAttributes ofRange(Range<Float> temperature, Range<Float> humidity, Range<Float> continentalness, Range<Float> erosion, Range<Float> depth, Range<Float> weirdness, float offset) {
        class_6544.class_6546 mcTemperature = class_6544.class_6546.method_38121((float)((Float)temperature.min()).floatValue(), (float)((Float)temperature.max()).floatValue());
        class_6544.class_6546 mcHumidity = class_6544.class_6546.method_38121((float)((Float)humidity.min()).floatValue(), (float)((Float)humidity.max()).floatValue());
        class_6544.class_6546 mcContinentalness = class_6544.class_6546.method_38121((float)((Float)continentalness.min()).floatValue(), (float)((Float)continentalness.max()).floatValue());
        class_6544.class_6546 mcErosion = class_6544.class_6546.method_38121((float)((Float)erosion.min()).floatValue(), (float)((Float)erosion.max()).floatValue());
        class_6544.class_6546 mcDepth = class_6544.class_6546.method_38121((float)((Float)depth.min()).floatValue(), (float)((Float)depth.max()).floatValue());
        class_6544.class_6546 mcWeirdness = class_6544.class_6546.method_38121((float)((Float)weirdness.min()).floatValue(), (float)((Float)weirdness.max()).floatValue());
        long mcOffset = class_6544.method_38665((float)offset);
        return (BiomeAttributes)new class_6544.class_4762(mcTemperature, mcHumidity, mcContinentalness, mcErosion, mcDepth, mcWeirdness, mcOffset);
    }

    public Range<Float> fullRange() {
        return (Range)this.FULL_RANGE;
    }

    public Optional<BiomeAttributes> defaultAttributes(RegistryReference<Biome> biome) {
        if (DEFAULT_ATTRIBUTES == null) {
            DEFAULT_ATTRIBUTES = new HashMap<ResourceKey, BiomeAttributes>();
            ImmutableList.Builder list = ImmutableList.builder();
            ((OverworldBiomeBuilderAccessor)new class_6554()).accessor$addBiomes(arg_0 -> ((ImmutableList.Builder)list).add(arg_0));
            for (Pair pair : list.build()) {
                DEFAULT_ATTRIBUTES.put((ResourceKey)((class_5321)pair.getSecond()).method_29177(), (BiomeAttributes)pair.getFirst());
            }
            DEFAULT_ATTRIBUTES.put((ResourceKey)class_1972.field_22076.method_29177(), (BiomeAttributes)class_6544.method_38117((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            DEFAULT_ATTRIBUTES.put((ResourceKey)class_1972.field_22077.method_29177(), (BiomeAttributes)class_6544.method_38117((float)0.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            DEFAULT_ATTRIBUTES.put((ResourceKey)class_1972.field_22075.method_29177(), (BiomeAttributes)class_6544.method_38117((float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.375f));
            DEFAULT_ATTRIBUTES.put((ResourceKey)class_1972.field_23859.method_29177(), (BiomeAttributes)class_6544.method_38117((float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.175f));
        }
        return Optional.ofNullable(DEFAULT_ATTRIBUTES.get(biome.location()));
    }
}

