/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1973;
import net.minecraft.class_1992;
import net.minecraft.class_2169;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4766;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8198;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.AttributedBiome;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.biome.provider.CheckerboardBiomeConfig;
import org.spongepowered.api.world.biome.provider.ConfigurableBiomeProvider;
import org.spongepowered.api.world.biome.provider.EndStyleBiomeConfig;
import org.spongepowered.api.world.biome.provider.FixedBiomeProvider;
import org.spongepowered.api.world.biome.provider.MultiNoiseBiomeConfig;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.level.biome.TheEndBiomeSourceAccessor;

public final class SpongeBiomeProviderFactory
implements BiomeProvider.Factory {
    public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> overworld() {
        class_2378 registry = SpongeCommon.vanillaRegistry(class_7924.field_43089);
        class_6880.class_6883 holder = registry.method_46747(class_8198.field_42992);
        return (ConfigurableBiomeProvider)class_4766.method_49503((class_6880)holder);
    }

    public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> multiNoise(MultiNoiseBiomeConfig config) {
        ArrayList<Pair> climateParams = new ArrayList<Pair>();
        for (AttributedBiome attributedBiome : config.attributedBiomes()) {
            climateParams.add(Pair.of((Object)((class_6544.class_4762)attributedBiome.attributes()), this.biomeHolder((RegistryReference<Biome>)attributedBiome.biome())));
        }
        return (ConfigurableBiomeProvider)class_4766.method_49501((class_6544.class_6547)new class_6544.class_6547(climateParams));
    }

    public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> nether() {
        class_2378 registry = SpongeCommon.vanillaRegistry(class_7924.field_43089);
        class_6880.class_6883 holder = registry.method_46747(class_8198.field_42991);
        return (ConfigurableBiomeProvider)class_4766.method_49503((class_6880)holder);
    }

    public ConfigurableBiomeProvider<EndStyleBiomeConfig> endStyle(EndStyleBiomeConfig config) {
        return (ConfigurableBiomeProvider)TheEndBiomeSourceAccessor.invoker$new(this.biomeHolder((RegistryReference<Biome>)config.endBiome()), this.biomeHolder((RegistryReference<Biome>)config.highlandsBiome()), this.biomeHolder((RegistryReference<Biome>)config.midlandsBiome()), this.biomeHolder((RegistryReference<Biome>)config.islandsBiome()), this.biomeHolder((RegistryReference<Biome>)config.barrensBiome()));
    }

    public ConfigurableBiomeProvider<EndStyleBiomeConfig> end() {
        return (ConfigurableBiomeProvider)class_2169.method_46680(this.registry());
    }

    public ConfigurableBiomeProvider<CheckerboardBiomeConfig> checkerboard(CheckerboardBiomeConfig config) {
        List biomes = config.biomes().stream().map(this::biomeHolder).collect(Collectors.toList());
        return (ConfigurableBiomeProvider)new class_1973((class_6885)class_6885.method_40242(biomes), config.scale());
    }

    public FixedBiomeProvider fixed(RegistryReference<Biome> biome) {
        Objects.requireNonNull(biome, "biome");
        return (FixedBiomeProvider)new class_1992(this.biomeHolder(biome));
    }

    private class_2378<class_1959> registry() {
        return SpongeCommon.vanillaRegistry(class_7924.field_41236);
    }

    private class_6880<class_1959> biomeHolder(RegistryReference<Biome> biome) {
        return this.registry().method_46747(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)((class_2960)biome.location())));
    }
}

