/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_3414;
import net.minecraft.class_4761;
import net.minecraft.class_4763;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.util.Color;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.BiomeTemplate;
import org.spongepowered.api.world.biome.climate.GrassColorModifier;
import org.spongepowered.api.world.biome.climate.GrassColorModifiers;
import org.spongepowered.api.world.biome.climate.TemperatureModifier;
import org.spongepowered.api.world.biome.climate.TemperatureModifiers;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeBiomeTemplate
extends Record
implements BiomeTemplate {
    private final ResourceKey key;
    private final class_1959 representedBiome;
    private final DataPack<BiomeTemplate> pack;

    public SpongeBiomeTemplate(ResourceKey key, class_1959 representedBiome, DataPack<BiomeTemplate> pack) {
        this.key = key;
        this.representedBiome = representedBiome;
        this.pack = pack;
    }

    public int contentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        JsonElement serialized = SpongeBiomeTemplate.encode(this, (class_5455)SpongeCommon.server().method_30611());
        try {
            return ((StringDataFormat)DataFormats.JSON.get()).read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Biome:\n" + String.valueOf(serialized), e);
        }
    }

    public Biome biome() {
        return (Biome)this.representedBiome;
    }

    public static JsonElement encode(BiomeTemplate template, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (JsonElement)class_1959.field_25819.encodeStart((DynamicOps)ops, (Object)((class_1959)template.biome())).getOrThrow();
    }

    public static class_1959 decode(JsonElement json, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (class_1959)class_1959.field_25819.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static BiomeTemplate decode(DataPack<BiomeTemplate> pack, ResourceKey key, JsonElement packEntry, class_5455 registryAccess) {
        class_1959 parsed = SpongeBiomeTemplate.decode(packEntry, registryAccess);
        return new SpongeBiomeTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeBiomeTemplate.class, "key;representedBiome;pack", "key", "representedBiome", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeBiomeTemplate.class, "key;representedBiome;pack", "key", "representedBiome", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeBiomeTemplate.class, "key;representedBiome;pack", "key", "representedBiome", "pack"}, this, o);
    }

    public ResourceKey key() {
        return this.key;
    }

    public class_1959 representedBiome() {
        return this.representedBiome;
    }

    public DataPack<BiomeTemplate> pack() {
        return this.pack;
    }

    public static class BuilderImpl
    extends AbstractDataPackEntryBuilder<Biome, BiomeTemplate, BiomeTemplate.Builder>
    implements BiomeTemplate.Builder {
        private static DataProviderLookup PROVIDER_LOOKUP = SpongeDataManager.getProviderRegistry().getProviderLookup(class_1959.class);
        private DataManipulator.Mutable manipulator = DataManipulator.mutableOf();

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<BiomeTemplate, Biome> valueExtractor() {
            return BiomeTemplate::biome;
        }

        public <V> BiomeTemplate.Builder add(Key<? extends Value<V>> key, V value) {
            if (!PROVIDER_LOOKUP.getProvider(key).isSupported(class_1959.class)) {
                throw new IllegalArgumentException(String.valueOf(key) + " is not supported for biomes");
            }
            this.manipulator.set(key, value);
            return this;
        }

        public BiomeTemplate.Builder reset() {
            this.manipulator = DataManipulator.mutableOf();
            this.key = null;
            this.pack = DataPacks.BIOME;
            return this;
        }

        public BiomeTemplate.Builder fromValue(Biome biome) {
            this.manipulator.set((Iterable)biome.getValues());
            return this;
        }

        public BiomeTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString((String)((StringDataFormat)DataFormats.JSON.get()).write(pack));
            class_1959 biome = SpongeBiomeTemplate.decode(json, (class_5455)SpongeCommon.server().method_30611());
            this.fromValue((Biome)biome);
            return this;
        }

        @Override
        protected BiomeTemplate build0() {
            Boolean precipitation = (Boolean)this.manipulator.require(Keys.HAS_PRECIPITATION);
            Double temperature = (Double)this.manipulator.require(Keys.BIOME_TEMPERATURE);
            Double downfall = (Double)this.manipulator.require(Keys.HUMIDITY);
            TemperatureModifier temperatureModifier = (TemperatureModifier)this.manipulator.getOrElse(Keys.TEMPERATURE_MODIFIER, (Object)((TemperatureModifier)TemperatureModifiers.NONE.get()));
            Color fogColor = (Color)this.manipulator.require(Keys.FOG_COLOR);
            Color waterColor = (Color)this.manipulator.require(Keys.WATER_COLOR);
            Color waterFogColor = (Color)this.manipulator.require(Keys.WATER_FOG_COLOR);
            Color skyColor = (Color)this.manipulator.require(Keys.SKY_COLOR);
            Optional foliageColor = this.manipulator.get(Keys.FOLIAGE_COLOR);
            Optional grassColor = this.manipulator.get(Keys.GRASS_COLOR);
            GrassColorModifier grassColorModifier = (GrassColorModifier)this.manipulator.getOrElse(Keys.GRASS_COLOR_MODIFIER, (Object)((GrassColorModifier)GrassColorModifiers.NONE.get()));
            Optional particleSettings = this.manipulator.get(Keys.AMBIENT_PARTICLE);
            Optional ambientSound = this.manipulator.get(Keys.AMBIENT_SOUND);
            Optional ambientMood = this.manipulator.get(Keys.AMBIENT_MOOD);
            Optional additionalSound = this.manipulator.get(Keys.AMBIENT_ADDITIONAL_SOUND);
            Optional backgroundMusic = this.manipulator.get(Keys.BACKGROUND_MUSIC);
            Double spawnChance = (Double)this.manipulator.require(Keys.SPAWN_CHANCE);
            Map spawners = (Map)this.manipulator.getOrElse(Keys.NATURAL_SPAWNERS, Map.of());
            Map spawnerCosts = (Map)this.manipulator.getOrElse(Keys.NATURAL_SPAWNER_COST, Map.of());
            Map features = (Map)this.manipulator.getOrElse(Keys.FEATURES, Map.of());
            List carvers = (List)this.manipulator.getOrElse(Keys.CARVERS, List.of());
            class_4763.class_4764 effectsBuilder = new class_4763.class_4764().method_24392(fogColor.rgb()).method_24395(waterColor.rgb()).method_24397(waterFogColor.rgb()).method_30820(skyColor.rgb()).method_30818((class_4763.class_5486)grassColorModifier);
            foliageColor.ifPresent(c -> effectsBuilder.method_30821(c.rgb()));
            grassColor.ifPresent(c -> effectsBuilder.method_30822(c.rgb()));
            particleSettings.ifPresent(ps -> effectsBuilder.method_24393((class_4761)ps));
            ambientSound.ifPresent(s -> effectsBuilder.method_24942(class_6880.method_40223((Object)((class_3414)s))));
            ambientMood.ifPresent(m -> effectsBuilder.method_24943((class_4968)m));
            additionalSound.ifPresent(s -> effectsBuilder.method_24944((class_4967)s));
            backgroundMusic.ifPresent(m -> effectsBuilder.method_27346((class_5195)m));
            class_5483.class_5496 spawnerBuilder = new class_5483.class_5496().method_31008(spawnChance.floatValue());
            spawners.forEach((cat, spawner) -> spawner.forEach(sp -> spawnerBuilder.method_31011((class_1311)cat, (class_5483.class_1964)sp)));
            spawnerCosts.forEach((type, cost) -> spawnerBuilder.method_31009((class_1299)type, cost.budget(), cost.charge()));
            class_2378 placedFeatureRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41245);
            class_2378 configuredWorldCarverRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41238);
            class_5485.class_5495 generationBuilder = new class_5485.class_5495(placedFeatureRegistry, configuredWorldCarverRegistry);
            features.forEach((step, list) -> list.forEach(feature -> generationBuilder.method_46676((class_2893.class_2895)step, class_6880.method_40223((Object)((class_6796)feature)))));
            carvers.forEach(carver -> generationBuilder.method_46675(class_6880.method_40223((Object)((class_2922)carver))));
            class_1959.class_1960 vanillaBuilder = new class_1959.class_1960().method_48164(precipitation.booleanValue()).method_8747(temperature.floatValue()).method_8727(downfall.floatValue()).method_30777((class_1959.class_5484)temperatureModifier).method_24379(effectsBuilder.method_24391()).method_30974(spawnerBuilder.method_31007()).method_30973(generationBuilder.method_46671());
            return new SpongeBiomeTemplate(this.key, vanillaBuilder.method_30972(), (DataPack<BiomeTemplate>)this.pack);
        }
    }
}

