/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome.provider;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_4766;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8197;
import net.minecraft.class_8198;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.biome.AttributedBiome;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.BiomeAttributes;
import org.spongepowered.api.world.biome.provider.MultiNoiseBiomeConfig;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.level.biome.MultiNoiseBiomeSourceAccessor;
import org.spongepowered.common.world.biome.provider.AbstractBiomeProviderConfig;

public final class SpongeMultiNoiseBiomeConfig
extends AbstractBiomeProviderConfig
implements MultiNoiseBiomeConfig {
    private final List<AttributedBiome> biomes;

    private SpongeMultiNoiseBiomeConfig(BuilderImpl builder) {
        super(builder.biomes.stream().map(AttributedBiome::biome).collect(Collectors.toList()));
        this.biomes = builder.biomes;
    }

    public List<AttributedBiome> attributedBiomes() {
        return this.biomes;
    }

    public static final class BuilderImpl
    implements MultiNoiseBiomeConfig.Builder {
        public final List<AttributedBiome> biomes = new ArrayList<AttributedBiome>();

        public MultiNoiseBiomeConfig.Builder addBiome(AttributedBiome biome) {
            this.biomes.add(Objects.requireNonNull(biome, "biome"));
            return this;
        }

        public MultiNoiseBiomeConfig.Builder addBiomes(List<AttributedBiome> biomes) {
            this.biomes.addAll((Collection<AttributedBiome>)Objects.requireNonNull(biomes, "biomes"));
            return this;
        }

        public MultiNoiseBiomeConfig.Builder addMcBiomes(Either<class_6544.class_6547<class_6880<class_1959>>, class_6880<class_8197>> biomes) {
            ((class_6544.class_6547)biomes.map(v -> v, v -> ((class_8197)v.comp_349()).method_49507())).method_38128().forEach(pair -> {
                ResourceKey key = RegistryTypes.BIOME.keyFor((RegistryHolder)Sponge.server(), (Object)((Biome)((class_6880)pair.getSecond()).comp_349()));
                RegistryReference biome = RegistryTypes.BIOME.referenced(key);
                this.biomes.add(AttributedBiome.of((RegistryReference)biome, (BiomeAttributes)((BiomeAttributes)pair.getFirst())));
            });
            return this;
        }

        public MultiNoiseBiomeConfig.Builder removeBiome(RegistryReference<Biome> biome) {
            Objects.requireNonNull(biome, "biome");
            Iterator<AttributedBiome> iter = this.biomes.iterator();
            while (iter.hasNext()) {
                if (!iter.next().biome().equals(biome)) continue;
                iter.remove();
                break;
            }
            return this;
        }

        public MultiNoiseBiomeConfig.Builder from(MultiNoiseBiomeConfig value) {
            this.biomes.clear();
            this.biomes.addAll(value.attributedBiomes());
            return this;
        }

        public MultiNoiseBiomeConfig.Builder reset() {
            this.biomes.clear();
            return this;
        }

        public @NonNull MultiNoiseBiomeConfig build() {
            if (this.biomes.isEmpty()) {
                throw new IllegalStateException("MultiNoise biome config requires at least one biome!");
            }
            return new SpongeMultiNoiseBiomeConfig(this);
        }
    }

    public static final class FactoryImpl
    implements MultiNoiseBiomeConfig.Factory {
        public MultiNoiseBiomeConfig nether() {
            class_2378 registry = SpongeCommon.vanillaRegistry(class_7924.field_43089);
            class_6880.class_6883 holder = registry.method_46747(class_8198.field_42991);
            MultiNoiseBiomeSourceAccessor biomeSource = (MultiNoiseBiomeSourceAccessor)class_4766.method_49503((class_6880)holder);
            return (MultiNoiseBiomeConfig)new BuilderImpl().addMcBiomes(biomeSource.accessor$parameters()).build();
        }

        public MultiNoiseBiomeConfig overworld() {
            class_2378 registry = SpongeCommon.vanillaRegistry(class_7924.field_43089);
            class_6880.class_6883 holder = registry.method_46747(class_8198.field_42992);
            MultiNoiseBiomeSourceAccessor biomeSource = (MultiNoiseBiomeSourceAccessor)class_4766.method_49503((class_6880)holder);
            return (MultiNoiseBiomeConfig)new BuilderImpl().addMcBiomes(biomeSource.accessor$parameters()).build();
        }
    }
}

