/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.class_1966;
import net.minecraft.class_2169;
import net.minecraft.class_2378;
import net.minecraft.class_2897;
import net.minecraft.class_3232;
import net.minecraft.class_3754;
import net.minecraft.class_4766;
import net.minecraft.class_5284;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8198;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.generation.ConfigurableChunkGenerator;
import org.spongepowered.api.world.generation.config.flat.FlatGeneratorConfig;
import org.spongepowered.api.world.generation.config.noise.NoiseGeneratorConfig;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.world.server.SpongeWorldTemplate;

public final class SpongeChunkGeneratorFactory
implements ChunkGenerator.Factory {
    public ConfigurableChunkGenerator<FlatGeneratorConfig> flat(FlatGeneratorConfig config) {
        return (ConfigurableChunkGenerator)new class_2897((class_3232)config);
    }

    private ConfigurableChunkGenerator<NoiseGeneratorConfig> noiseBasedChunkGenerator(class_1966 biomeSource, class_6880<class_5284> noiseGeneratorSettings) {
        return (ConfigurableChunkGenerator)new class_3754(biomeSource, noiseGeneratorSettings);
    }

    public ConfigurableChunkGenerator<NoiseGeneratorConfig> noise(BiomeProvider provider, NoiseGeneratorConfig config) {
        class_1966 biomeSource = (class_1966)Objects.requireNonNull(provider, "provider");
        class_5284 noiseGeneratorSettings = (class_5284)Objects.requireNonNull(config, "config");
        return this.noiseBasedChunkGenerator(biomeSource, (class_6880<class_5284>)class_6880.method_40223((Object)noiseGeneratorSettings));
    }

    public ConfigurableChunkGenerator<NoiseGeneratorConfig> overworld() {
        class_2378 noiseGeneratorSettingsRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41243);
        class_2378 registry = SpongeCommon.vanillaRegistry(class_7924.field_43089);
        class_6880.class_6883 holder = registry.method_46747(class_8198.field_42992);
        class_4766 biomeSource = class_4766.method_49503((class_6880)holder);
        return this.noiseBasedChunkGenerator((class_1966)biomeSource, (class_6880<class_5284>)noiseGeneratorSettingsRegistry.method_46747(class_5284.field_26355));
    }

    public ConfigurableChunkGenerator<NoiseGeneratorConfig> theNether() {
        class_2378 noiseGeneratorSettingsRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41243);
        class_2378 registry = SpongeCommon.vanillaRegistry(class_7924.field_43089);
        class_6880.class_6883 holder = registry.method_46747(class_8198.field_42991);
        class_4766 biomeSource = class_4766.method_49503((class_6880)holder);
        return this.noiseBasedChunkGenerator((class_1966)biomeSource, (class_6880<class_5284>)noiseGeneratorSettingsRegistry.method_46747(class_5284.field_26357));
    }

    public ConfigurableChunkGenerator<NoiseGeneratorConfig> theEnd() {
        class_2378 biomeRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41236);
        class_2378 noiseGeneratorSettingsRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41243);
        class_2169 biomeSource = class_2169.method_46680(biomeRegistry);
        return this.noiseBasedChunkGenerator((class_1966)biomeSource, (class_6880<class_5284>)noiseGeneratorSettingsRegistry.method_46747(class_5284.field_26358));
    }

    public ChunkGenerator fromDataPack(DataView pack) throws IOException {
        JsonElement json = JsonParser.parseString((String)((StringDataFormat)DataFormats.JSON.get()).write(pack));
        return (ChunkGenerator)SpongeWorldTemplate.decodeStem(json, (class_5455)SpongeCommon.server().method_30611()).comp_1013();
    }
}

