/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation;

import java.util.Objects;
import net.minecraft.class_5285;
import org.spongepowered.api.world.generation.config.WorldGenerationConfig;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.SeedUtil;

public final class SpongeWorldGenerationConfigBuilder
implements WorldGenerationConfig.Builder {
    private long seed;
    private boolean generateFeatures;
    private boolean generateBonusChest;

    public WorldGenerationConfig.Builder seed(long seed) {
        this.seed = seed;
        return this;
    }

    public void seed(String seed) {
        this.seed = SeedUtil.compute(seed);
    }

    public WorldGenerationConfig.Builder generateStructures(boolean generateStructures) {
        this.generateFeatures = generateStructures;
        return this;
    }

    public WorldGenerationConfig.Builder generateBonusChest(boolean generateBonusChest) {
        this.generateBonusChest = generateBonusChest;
        return this;
    }

    public WorldGenerationConfig.Builder reset() {
        class_5285 defaultSettings = SpongeCommon.server().method_27728().method_28057();
        this.seed = defaultSettings.method_28028();
        this.generateFeatures = defaultSettings.method_28029();
        this.generateBonusChest = defaultSettings.method_28030();
        return this;
    }

    public WorldGenerationConfig.Builder from(WorldGenerationConfig value) {
        this.seed = Objects.requireNonNull(value, "value").seed();
        this.generateFeatures = value.generateStructures();
        this.generateBonusChest = value.generateBonusChest();
        return this;
    }

    public WorldGenerationConfig build() {
        return (WorldGenerationConfig)new class_5285(this.seed, this.generateFeatures, this.generateBonusChest);
    }
}

