/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.flat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6814;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.generation.config.flat.FlatGeneratorConfig;
import org.spongepowered.api.world.generation.config.flat.LayerConfig;
import org.spongepowered.api.world.generation.structure.StructureSet;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.level.levelgen.flat.FlatLevelGeneratorSettingsAccessor;

public final class SpongeFlatGeneratorConfig {

    public static final class BuilderImpl
    implements FlatGeneratorConfig.Builder {
        public final List<LayerConfig> layers = new ArrayList<LayerConfig>();
        public @Nullable RegistryReference<Biome> biome;
        public boolean performDecoration;
        public boolean populateLakes;
        private @Nullable List<StructureSet> structureSets;

        public BuilderImpl() {
            this.reset();
        }

        public FlatGeneratorConfig.Builder addLayer(int index, LayerConfig config) {
            this.layers.add(index, Objects.requireNonNull(config, "config"));
            return this;
        }

        public FlatGeneratorConfig.Builder addLayer(LayerConfig config) {
            this.layers.add(Objects.requireNonNull(config, "config"));
            return this;
        }

        public FlatGeneratorConfig.Builder addLayers(List<LayerConfig> layers) {
            this.layers.addAll((Collection<LayerConfig>)Objects.requireNonNull(layers, "layers"));
            return this;
        }

        public FlatGeneratorConfig.Builder removeLayer(int index) {
            this.layers.remove(index);
            return this;
        }

        public FlatGeneratorConfig.Builder biome(RegistryReference<Biome> biome) {
            this.biome = Objects.requireNonNull(biome, "biome");
            return this;
        }

        public FlatGeneratorConfig.Builder performDecoration(boolean performDecoration) {
            this.performDecoration = performDecoration;
            return this;
        }

        public FlatGeneratorConfig.Builder populateLakes(boolean populateLakes) {
            this.populateLakes = populateLakes;
            return this;
        }

        public FlatGeneratorConfig.Builder structureSets(@Nullable List<StructureSet> structureSets) {
            this.structureSets = structureSets;
            return this;
        }

        public FlatGeneratorConfig.Builder reset() {
            this.biome = null;
            this.layers.clear();
            this.performDecoration = false;
            this.populateLakes = true;
            this.structureSets = null;
            return this;
        }

        public FlatGeneratorConfig.Builder from(FlatGeneratorConfig value) {
            this.biome = value.biome();
            this.layers.addAll(value.layers());
            this.performDecoration = value.performDecoration();
            this.populateLakes = value.populateLakes();
            this.structureSets = value.structureSets().orElse(null);
            return this;
        }

        public @NonNull FlatGeneratorConfig build() {
            if (this.biome == null) {
                throw new IllegalStateException("Flat generation requires a biome to be specified!");
            }
            if (this.layers.isEmpty()) {
                throw new IllegalStateException("Flat generation requires at least 1 Layer!");
            }
            class_2378 biomeRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41236);
            class_2378 placedFeatureRegistryLookup = SpongeCommon.vanillaRegistry(class_7924.field_41245);
            class_6880.class_6883 biome = biomeRegistry.method_46747(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)((class_2960)this.biome.location())));
            return (FlatGeneratorConfig)FlatLevelGeneratorSettingsAccessor.invoker$new(this.structureSets == null ? Optional.empty() : Optional.of(class_6885.method_40244(class_6880::method_40223, this.structureSets)), this.layers, this.populateLakes, this.performDecoration, Optional.of(biome), (class_6880.class_6883<class_1959>)biome, (class_6880<class_6796>)placedFeatureRegistryLookup.method_46747(class_6814.field_36007), (class_6880<class_6796>)placedFeatureRegistryLookup.method_46747(class_6814.field_36008));
        }
    }
}

