/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.noise;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2680;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5455;
import net.minecraft.class_6554;
import net.minecraft.class_6686;
import net.minecraft.class_6903;
import net.minecraft.class_6953;
import net.minecraft.class_7225;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.biome.BiomeAttributes;
import org.spongepowered.api.world.generation.config.SurfaceRule;
import org.spongepowered.api.world.generation.config.noise.NoiseConfig;
import org.spongepowered.api.world.generation.config.noise.NoiseConfigs;
import org.spongepowered.api.world.generation.config.noise.NoiseGeneratorConfig;
import org.spongepowered.api.world.generation.config.noise.NoiseGeneratorConfigTemplate;
import org.spongepowered.api.world.generation.config.noise.NoiseGeneratorConfigs;
import org.spongepowered.api.world.generation.config.noise.NoiseRouter;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeNoiseGeneratorConfigTemplate
extends Record
implements NoiseGeneratorConfigTemplate {
    private final ResourceKey key;
    private final class_5284 representedSettings;
    private final DataPack<NoiseGeneratorConfigTemplate> pack;

    public SpongeNoiseGeneratorConfigTemplate(ResourceKey key, class_5284 representedSettings, DataPack<NoiseGeneratorConfigTemplate> pack) {
        this.key = key;
        this.representedSettings = representedSettings;
        this.pack = pack;
    }

    public NoiseGeneratorConfig config() {
        return (NoiseGeneratorConfig)this.representedSettings;
    }

    public int contentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        JsonElement serialized = SpongeNoiseGeneratorConfigTemplate.encode(this, (class_5455)SpongeCommon.server().method_30611());
        try {
            return ((StringDataFormat)DataFormats.JSON.get()).read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized NoiseGeneratorConfig:\n" + String.valueOf(serialized), e);
        }
    }

    public static JsonElement encode(NoiseGeneratorConfigTemplate template, class_5455 registryAccess) {
        return (JsonElement)class_5284.field_24780.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((class_5284)template.config())).getOrThrow();
    }

    public static class_5284 decode(JsonElement json, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (class_5284)class_5284.field_24780.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static NoiseGeneratorConfigTemplate decode(DataPack<NoiseGeneratorConfigTemplate> pack, ResourceKey key, JsonElement packEntry, class_5455 registryAccess) {
        class_5284 parsed = SpongeNoiseGeneratorConfigTemplate.decode(packEntry, registryAccess);
        return new SpongeNoiseGeneratorConfigTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeNoiseGeneratorConfigTemplate.class, "key;representedSettings;pack", "key", "representedSettings", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeNoiseGeneratorConfigTemplate.class, "key;representedSettings;pack", "key", "representedSettings", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeNoiseGeneratorConfigTemplate.class, "key;representedSettings;pack", "key", "representedSettings", "pack"}, this, o);
    }

    public ResourceKey key() {
        return this.key;
    }

    public class_5284 representedSettings() {
        return this.representedSettings;
    }

    public DataPack<NoiseGeneratorConfigTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<NoiseGeneratorConfig, NoiseGeneratorConfigTemplate, NoiseGeneratorConfigTemplate.Builder>
    implements NoiseGeneratorConfigTemplate.Builder {
        public NoiseConfig noiseConfig;
        public BlockState defaultBlock;
        public BlockState defaultFluid;
        public int seaLevel;
        public boolean aquifers;
        public boolean oreVeins;
        public boolean legacyRandomSource;
        public boolean disableMobGeneration;
        public SurfaceRule surfaceRule;
        private NoiseRouter router;
        private List<BiomeAttributes> spawnTargets;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<NoiseGeneratorConfigTemplate, NoiseGeneratorConfig> valueExtractor() {
            return NoiseGeneratorConfigTemplate::config;
        }

        public NoiseGeneratorConfigTemplate.Builder noiseConfig(NoiseConfig config) {
            this.noiseConfig = Objects.requireNonNull(config, "config");
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder defaultBlock(BlockState block) {
            this.defaultBlock = Objects.requireNonNull(block, "block");
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder defaultFluid(BlockState fluid) {
            this.defaultFluid = Objects.requireNonNull(fluid, "fluid");
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder surfaceRule(SurfaceRule rule) {
            this.surfaceRule = rule;
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder seaLevel(int y) {
            this.seaLevel = y;
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder mobGeneration(boolean mobGeneration) {
            this.disableMobGeneration = !mobGeneration;
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder aquifers(boolean enableAquifers) {
            this.aquifers = enableAquifers;
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder oreVeins(boolean enableOreVeins) {
            this.oreVeins = enableOreVeins;
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder randomSource(boolean useLegacyRandomSource) {
            this.legacyRandomSource = useLegacyRandomSource;
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder noiseRouter(NoiseRouter router) {
            this.router = router;
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder spawnTargets(List<BiomeAttributes> spawnTargets) {
            this.spawnTargets = spawnTargets;
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder reset() {
            this.noiseConfig = (NoiseConfig)NoiseConfigs.OVERWORLD.get();
            this.defaultBlock = (BlockState)((BlockType)BlockTypes.STONE.get()).defaultState();
            this.defaultFluid = (BlockState)((BlockType)BlockTypes.WATER.get()).defaultState();
            this.surfaceRule = SurfaceRule.overworld();
            this.seaLevel = 63;
            this.aquifers = false;
            this.oreVeins = false;
            this.legacyRandomSource = false;
            this.router = ((NoiseGeneratorConfig)NoiseGeneratorConfigs.OVERWORLD.get()).noiseRouter();
            this.spawnTargets = new class_6554().method_39168();
            this.pack = DataPacks.NOISE_GENERATOR_CONFIG;
            this.key = null;
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder fromValue(NoiseGeneratorConfig value) {
            this.noiseConfig = value.noiseConfig();
            this.defaultBlock = value.defaultBlock();
            this.defaultFluid = value.defaultFluid();
            this.surfaceRule = value.surfaceRule();
            this.seaLevel = value.seaLevel();
            this.aquifers = value.aquifers();
            this.legacyRandomSource = value.legacyRandomSource();
            return this;
        }

        public NoiseGeneratorConfigTemplate.Builder fromDataPack(DataView datapack) throws IOException {
            JsonElement json = JsonParser.parseString((String)((StringDataFormat)DataFormats.JSON.get()).write(datapack));
            class_5284 decoded = SpongeNoiseGeneratorConfigTemplate.decode(json, (class_5455)SpongeCommon.server().method_30611());
            return this.fromValue((NoiseGeneratorConfig)decoded);
        }

        @Override
        protected NoiseGeneratorConfigTemplate build0() {
            class_5284 settings = new class_5284((class_5309)this.noiseConfig, (class_2680)this.defaultBlock, (class_2680)this.defaultFluid, (class_6953)this.router, (class_6686.class_6708)this.surfaceRule, this.spawnTargets, this.seaLevel, this.disableMobGeneration, this.aquifers, this.oreVeins, this.legacyRandomSource);
            return new SpongeNoiseGeneratorConfigTemplate(this.key, settings, (DataPack<NoiseGeneratorConfigTemplate>)this.pack);
        }
    }
}

