/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config.noise;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import net.minecraft.class_5216;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.generation.config.noise.Noise;
import org.spongepowered.api.world.generation.config.noise.NoiseTemplate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeNoiseTemplate
extends Record
implements NoiseTemplate {
    private final ResourceKey key;
    private final class_5216.class_5487 noiseParameters;
    private final DataPack<NoiseTemplate> pack;

    public SpongeNoiseTemplate(ResourceKey key, class_5216.class_5487 noiseParameters, DataPack<NoiseTemplate> pack) {
        this.key = key;
        this.noiseParameters = noiseParameters;
        this.pack = pack;
    }

    public Noise noise() {
        return (Noise)this.noiseParameters;
    }

    public int contentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        JsonElement serialized = SpongeNoiseTemplate.encode(this, (class_5455)SpongeCommon.server().method_30611());
        try {
            return ((StringDataFormat)DataFormats.JSON.get()).read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Noise:\n" + String.valueOf(serialized), e);
        }
    }

    public static JsonElement encode(NoiseTemplate template, class_5455 registryAccess) {
        return (JsonElement)class_5216.class_5487.field_35424.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((class_5216.class_5487)template.noise())).getOrThrow();
    }

    public static class_5216.class_5487 decode(JsonElement json, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (class_5216.class_5487)class_5216.class_5487.field_35424.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static SpongeNoiseTemplate decode(DataPack<NoiseTemplate> pack, ResourceKey key, JsonElement packEntry, class_5455 registryAccess) {
        class_5216.class_5487 parsed = SpongeNoiseTemplate.decode(packEntry, registryAccess);
        return new SpongeNoiseTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeNoiseTemplate.class, "key;noiseParameters;pack", "key", "noiseParameters", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeNoiseTemplate.class, "key;noiseParameters;pack", "key", "noiseParameters", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeNoiseTemplate.class, "key;noiseParameters;pack", "key", "noiseParameters", "pack"}, this, o);
    }

    public ResourceKey key() {
        return this.key;
    }

    public class_5216.class_5487 noiseParameters() {
        return this.noiseParameters;
    }

    public DataPack<NoiseTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<Noise, NoiseTemplate, NoiseTemplate.Builder>
    implements NoiseTemplate.Builder {
        private @Nullable Integer octave;
        private @Nullable List<Double> amplitudes;

        public BuilderImpl() {
            this.reset();
        }

        public NoiseTemplate.Builder fromValue(Noise noise) {
            this.octave(noise.octave()).amplitudes(noise.amplitudes());
            return this;
        }

        public NoiseTemplate.Builder octave(int octave) {
            this.octave = octave;
            return this;
        }

        public NoiseTemplate.Builder amplitudes(double ... amplitudes) {
            this.amplitudes = DoubleStream.of(amplitudes).boxed().toList();
            return this;
        }

        public NoiseTemplate.Builder amplitudes(List<Double> amplitudes) {
            this.amplitudes = amplitudes;
            return this;
        }

        public NoiseTemplate.Builder reset() {
            this.octave = null;
            this.amplitudes = null;
            this.pack = DataPacks.NOISE;
            this.key = null;
            return this;
        }

        public NoiseTemplate.Builder fromDataPack(DataView datapack) throws IOException {
            JsonElement json = JsonParser.parseString((String)((StringDataFormat)DataFormats.JSON.get()).write(datapack));
            return this.fromValue((Noise)SpongeNoiseTemplate.decode(json, (class_5455)SpongeCommon.server().method_30611()));
        }

        @Override
        public Function<NoiseTemplate, Noise> valueExtractor() {
            return NoiseTemplate::noise;
        }

        @Override
        protected SpongeNoiseTemplate build0() {
            Objects.requireNonNull(this.octave, "octave");
            Objects.requireNonNull(this.amplitudes, "amplitudes");
            class_5216.class_5487 params = new class_5216.class_5487(this.octave.intValue(), new ArrayList<Double>(this.amplitudes));
            return new SpongeNoiseTemplate(this.key, params, (DataPack<NoiseTemplate>)this.pack);
        }
    }
}

