/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.structure;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_6871;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.generation.structure.StructurePlacement;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3i;

public class SpongeStructurePlacementBuilder
implements StructurePlacement.Builder,
StructurePlacement.Builder.RandomSpread,
StructurePlacement.Builder.ConcentricRings {
    private Boolean randomSpread;
    private class_2382 locateOffset = class_2382.field_11176;
    private int salt = 0;
    private Integer spacing;
    private Integer separation;
    private class_6873 randomSpreadType = class_6873.field_36421;
    private Integer distance;
    private Integer spread;
    private Integer count;
    private class_6885<class_1959> preferredBiomes = class_6885.method_40246((class_6880[])new class_6880[0]);

    public StructurePlacement.Builder reset() {
        this.randomSpread = null;
        this.locateOffset = class_2382.field_11176;
        this.spacing = null;
        this.separation = null;
        this.salt = 0;
        this.randomSpreadType = class_6873.field_36421;
        this.distance = null;
        this.spread = null;
        this.count = null;
        this.preferredBiomes = class_6885.method_40246((class_6880[])new class_6880[0]);
        return this;
    }

    public StructurePlacement.Builder.RandomSpread randomSpread(Vector3i locateOffset, int salt) {
        this.randomSpread = true;
        this.salt = salt;
        this.locateOffset = VecHelper.toVanillaVector3i(locateOffset);
        return this;
    }

    public StructurePlacement.Builder.RandomSpread randomSpread(int salt) {
        this.randomSpread = true;
        this.salt = salt;
        return this;
    }

    public StructurePlacement.Builder.RandomSpread linear() {
        this.randomSpreadType = class_6873.field_36421;
        return this;
    }

    public StructurePlacement.Builder.RandomSpread triangular() {
        this.randomSpreadType = class_6873.field_36422;
        return this;
    }

    public StructurePlacement.Builder.RandomSpread spacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public StructurePlacement.Builder.RandomSpread separation(int separation) {
        this.separation = separation;
        return this;
    }

    public StructurePlacement.Builder.ConcentricRings concentricRings() {
        this.randomSpread = false;
        this.salt = 0;
        return this;
    }

    public StructurePlacement.Builder.ConcentricRings concentricRings(Vector3i locateOffset, int salt) {
        this.randomSpread = false;
        this.salt = salt;
        this.locateOffset = VecHelper.toVanillaVector3i(locateOffset);
        return this;
    }

    public StructurePlacement.Builder.ConcentricRings distance(int distance) {
        this.distance = distance;
        return this;
    }

    public StructurePlacement.Builder.ConcentricRings spread(int spread) {
        this.spread = spread;
        return this;
    }

    public StructurePlacement.Builder.ConcentricRings count(int count) {
        this.count = count;
        return this;
    }

    public StructurePlacement.Builder.ConcentricRings preferredBiomes(Tag<Biome> preferredBiomes) {
        class_2378 registry = SpongeCommon.vanillaRegistry(class_7924.field_41236);
        return this;
    }

    public StructurePlacement build() {
        class_6874.class_7154 method = class_6874.class_7154.field_37782;
        float frequency = 1.0f;
        Optional exclusionZone = Optional.empty();
        if (this.randomSpread.booleanValue()) {
            Objects.requireNonNull(this.spacing, "spacing");
            Objects.requireNonNull(this.separation, "spacing");
            return (StructurePlacement)new class_6872(this.locateOffset, method, 1.0f, this.salt, exclusionZone, this.spacing.intValue(), this.separation.intValue(), this.randomSpreadType);
        }
        Objects.requireNonNull(this.distance, "distance");
        Objects.requireNonNull(this.spread, "spread");
        Objects.requireNonNull(this.count, "count");
        return (StructurePlacement)new class_6871(this.locateOffset, method, 1.0f, this.salt, exclusionZone, this.distance.intValue(), this.spread.intValue(), this.count.intValue(), this.preferredBiomes);
    }
}

