/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.structure;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_3195;
import net.minecraft.class_5455;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7059;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.generation.structure.Structure;
import org.spongepowered.api.world.generation.structure.StructurePlacement;
import org.spongepowered.api.world.generation.structure.StructureSet;
import org.spongepowered.api.world.generation.structure.StructureSetTemplate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeStructureSetTemplate
extends Record
implements StructureSetTemplate {
    private final ResourceKey key;
    private final class_7059 representedStructureSet;
    private final DataPack<StructureSetTemplate> pack;

    public SpongeStructureSetTemplate(ResourceKey key, class_7059 representedStructureSet, DataPack<StructureSetTemplate> pack) {
        this.key = key;
        this.representedStructureSet = representedStructureSet;
        this.pack = pack;
    }

    public StructureSet structureSet() {
        return (StructureSet)this.representedStructureSet;
    }

    public int contentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        JsonElement serialized = SpongeStructureSetTemplate.encode(this, (class_5455)SpongeCommon.server().method_30611());
        try {
            return ((StringDataFormat)DataFormats.JSON.get()).read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Structure:\n" + String.valueOf(serialized), e);
        }
    }

    public static JsonElement encode(StructureSetTemplate template, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (JsonElement)class_7059.field_37195.encodeStart((DynamicOps)ops, (Object)((class_7059)template.structureSet())).getOrThrow();
    }

    public static class_7059 decode(JsonElement json, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (class_7059)class_7059.field_37195.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static SpongeStructureSetTemplate decode(DataPack<StructureSetTemplate> pack, ResourceKey key, JsonElement packEntry, class_5455 registryAccess) {
        class_7059 parsed = SpongeStructureSetTemplate.decode(packEntry, registryAccess);
        return new SpongeStructureSetTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeStructureSetTemplate.class, "key;representedStructureSet;pack", "key", "representedStructureSet", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeStructureSetTemplate.class, "key;representedStructureSet;pack", "key", "representedStructureSet", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeStructureSetTemplate.class, "key;representedStructureSet;pack", "key", "representedStructureSet", "pack"}, this, o);
    }

    public ResourceKey key() {
        return this.key;
    }

    public class_7059 representedStructureSet() {
        return this.representedStructureSet;
    }

    public DataPack<StructureSetTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<StructureSet, StructureSetTemplate, StructureSetTemplate.Builder>
    implements StructureSetTemplate.Builder {
        private @Nullable class_6874 placement;
        private List<class_7059.class_7060> structureSelectionEntries = new ArrayList<class_7059.class_7060>();

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<StructureSetTemplate, StructureSet> valueExtractor() {
            return StructureSetTemplate::structureSet;
        }

        public StructureSetTemplate.Builder fromValue(StructureSet structureSet) {
            class_7059 mcSet = (class_7059)structureSet;
            this.structureSelectionEntries = mcSet.comp_510();
            this.placement = mcSet.comp_511();
            return this;
        }

        public StructureSetTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString((String)((StringDataFormat)DataFormats.JSON.get()).write(pack));
            class_7059 decoded = SpongeStructureSetTemplate.decode(json, (class_5455)SpongeCommon.server().method_30611());
            this.structureSelectionEntries = decoded.comp_510();
            this.placement = decoded.comp_511();
            return this;
        }

        public StructureSetTemplate.Builder placement(StructurePlacement placement) {
            this.placement = (class_6874)placement;
            return this;
        }

        public StructureSetTemplate.Builder add(Structure structure, int weight) {
            class_6880.class_6883 holder;
            class_2378 registry = SpongeCommon.vanillaRegistry(class_7924.field_41246);
            class_3195 mcStructure = (class_3195)structure;
            try {
                holder = registry.method_40269((Object)mcStructure);
            }
            catch (Exception e) {
                holder = class_6880.method_40223((Object)mcStructure);
            }
            this.structureSelectionEntries.add(new class_7059.class_7060((class_6880)holder, weight));
            return this;
        }

        public StructureSetTemplate.Builder reset() {
            super.reset();
            this.pack = DataPacks.STRUCTURE_SET;
            this.placement = null;
            this.structureSelectionEntries = new ArrayList<class_7059.class_7060>();
            return this;
        }

        @Override
        protected SpongeStructureSetTemplate build0() {
            Objects.requireNonNull(this.placement, "placement");
            return new SpongeStructureSetTemplate(this.key, new class_7059(this.structureSelectionEntries, this.placement), (DataPack<StructureSetTemplate>)this.pack);
        }
    }
}

