/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.structure;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_3195;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.world.generation.structure.Structure;
import org.spongepowered.api.world.generation.structure.StructureTemplate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.AbstractDataPackEntryBuilder;

public final class SpongeStructureTemplate
extends Record
implements StructureTemplate {
    private final ResourceKey key;
    private final class_3195 representedStructure;
    private final DataPack<StructureTemplate> pack;

    public SpongeStructureTemplate(ResourceKey key, class_3195 representedStructure, DataPack<StructureTemplate> pack) {
        this.key = key;
        this.representedStructure = representedStructure;
        this.pack = pack;
    }

    public Structure structure() {
        return (Structure)this.representedStructure;
    }

    public int contentVersion() {
        return 0;
    }

    public DataContainer toContainer() {
        JsonElement serialized = SpongeStructureTemplate.encode(this, (class_5455)SpongeCommon.server().method_30611());
        try {
            return ((StringDataFormat)DataFormats.JSON.get()).read(serialized.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read deserialized Structure:\n" + String.valueOf(serialized), e);
        }
    }

    public static JsonElement encode(StructureTemplate template, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (JsonElement)class_3195.field_37744.encodeStart((DynamicOps)ops, (Object)((class_3195)template.structure())).getOrThrow();
    }

    public static class_3195 decode(JsonElement json, class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        return (class_3195)class_3195.field_37744.parse((DynamicOps)ops, (Object)json).getOrThrow();
    }

    public static SpongeStructureTemplate decode(DataPack<StructureTemplate> pack, ResourceKey key, JsonElement packEntry, class_5455 registryAccess) {
        class_3195 parsed = SpongeStructureTemplate.decode(packEntry, registryAccess);
        return new SpongeStructureTemplate(key, parsed, pack);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SpongeStructureTemplate.class, "key;representedStructure;pack", "key", "representedStructure", "pack"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SpongeStructureTemplate.class, "key;representedStructure;pack", "key", "representedStructure", "pack"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SpongeStructureTemplate.class, "key;representedStructure;pack", "key", "representedStructure", "pack"}, this, o);
    }

    public ResourceKey key() {
        return this.key;
    }

    public class_3195 representedStructure() {
        return this.representedStructure;
    }

    public DataPack<StructureTemplate> pack() {
        return this.pack;
    }

    public static final class BuilderImpl
    extends AbstractDataPackEntryBuilder<Structure, StructureTemplate, StructureTemplate.Builder>
    implements StructureTemplate.Builder {
        private @Nullable class_3195 structure;

        public BuilderImpl() {
            this.reset();
        }

        @Override
        public Function<StructureTemplate, Structure> valueExtractor() {
            return StructureTemplate::structure;
        }

        public StructureTemplate.Builder fromValue(Structure structure) {
            this.structure = (class_3195)structure;
            return this;
        }

        public StructureTemplate.Builder fromDataPack(DataView pack) throws IOException {
            JsonElement json = JsonParser.parseString((String)((StringDataFormat)DataFormats.JSON.get()).write(pack));
            this.structure = SpongeStructureTemplate.decode(json, (class_5455)SpongeCommon.server().method_30611());
            return this;
        }

        public StructureTemplate.Builder reset() {
            this.key = null;
            this.pack = DataPacks.STRUCTURE;
            this.structure = null;
            return this;
        }

        @Override
        protected SpongeStructureTemplate build0() {
            Objects.requireNonNull(this.structure, "Structure");
            return new SpongeStructureTemplate(this.key, this.structure, (DataPack<StructureTemplate>)this.pack);
        }
    }
}

