/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.level.chunk;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.CollectionValue;
import org.spongepowered.api.data.value.MapValue;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.scheduler.ScheduledUpdateList;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.HeightType;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.ChunkState;
import org.spongepowered.api.world.chunk.ChunkStates;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeEmptyChunk
implements WorldChunk {
    private final class_1937 level;
    private final class_2791 chunk;
    private @Nullable Vector3i blockMin;
    private @Nullable Vector3i blockMax;

    public SpongeEmptyChunk(class_1937 level, class_2791 chunk) {
        this.level = level;
        this.chunk = chunk;
    }

    public Palette<BlockState, BlockType> blockPalette() {
        return ((World)this.level).blockPalette();
    }

    public World<?, ?> world() {
        return (World)this.level;
    }

    public boolean isEmpty() {
        return true;
    }

    public ChunkState state() {
        return (ChunkState)ChunkStates.EMPTY.get();
    }

    public Vector3i min() {
        if (this.blockMin == null) {
            this.blockMin = SpongeChunkLayout.INSTANCE.forceToWorld(this.chunkPosition());
        }
        return this.blockMin;
    }

    public Vector3i max() {
        if (this.blockMax == null) {
            this.blockMax = this.min().add(new Vector3i(16, 256, 16)).sub(1, 1, 1);
        }
        return this.blockMax;
    }

    public Vector3i chunkPosition() {
        class_1923 pos = this.chunk.method_12004();
        return new Vector3i(pos.field_9181, 0, pos.field_9180);
    }

    public boolean contains(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    public Ticks inhabitedTime() {
        return Ticks.zero();
    }

    public double regionalDifficultyFactor() {
        return 0.0;
    }

    public double regionalDifficultyPercentage() {
        return 0.0;
    }

    private IllegalStateException emptyChunkError() {
        return new IllegalStateException("Method not allowed on empty Chunk");
    }

    public void addEntity(Entity entity) {
        throw this.emptyChunkError();
    }

    public void setInhabitedTime(Ticks newInhabitedTime) {
        throw this.emptyChunkError();
    }

    public Biome biome(int x, int y, int z) {
        throw this.emptyChunkError();
    }

    public VolumeStream<WorldChunk, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw this.emptyChunkError();
    }

    public boolean setBiome(int x, int y, int z, Biome biome) {
        throw this.emptyChunkError();
    }

    public BlockState block(int x, int y, int z) {
        throw this.emptyChunkError();
    }

    public FluidState fluid(int x, int y, int z) {
        throw this.emptyChunkError();
    }

    public int highestYAt(int x, int z) {
        throw this.emptyChunkError();
    }

    public VolumeStream<WorldChunk, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw this.emptyChunkError();
    }

    public boolean removeBlock(int x, int y, int z) {
        throw this.emptyChunkError();
    }

    public boolean setBlock(int x, int y, int z, BlockState blockState, BlockChangeFlag flag) {
        throw this.emptyChunkError();
    }

    public Collection<? extends BlockEntity> blockEntities() {
        throw this.emptyChunkError();
    }

    public Optional<? extends BlockEntity> blockEntity(int x, int y, int z) {
        throw this.emptyChunkError();
    }

    public VolumeStream<WorldChunk, BlockEntity> blockEntityStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw this.emptyChunkError();
    }

    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        throw this.emptyChunkError();
    }

    public void removeBlockEntity(int x, int y, int z) {
        throw this.emptyChunkError();
    }

    public Collection<? extends Player> players() {
        return Collections.emptyList();
    }

    public Optional<Entity> entity(UUID uuid) {
        return Optional.empty();
    }

    public Collection<? extends Entity> entities() {
        return Collections.emptyList();
    }

    public <T extends Entity> Collection<? extends T> entities(Class<? extends T> entityClass, AABB box, @Nullable Predicate<? super T> predicate) {
        return Collections.emptyList();
    }

    public Collection<? extends Entity> entities(AABB box, Predicate<? super Entity> filter) {
        return Collections.emptyList();
    }

    public VolumeStream<WorldChunk, Entity> entityStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw this.emptyChunkError();
    }

    public <E extends Entity> E createEntity(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        throw this.emptyChunkError();
    }

    public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        throw this.emptyChunkError();
    }

    public Optional<Entity> createEntity(DataContainer entityContainer) {
        throw this.emptyChunkError();
    }

    public Optional<Entity> createEntity(DataContainer entityContainer, Vector3d position) {
        throw this.emptyChunkError();
    }

    public boolean spawnEntity(Entity entity) {
        throw this.emptyChunkError();
    }

    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        throw this.emptyChunkError();
    }

    public int height(HeightType type, int x, int z) {
        throw this.emptyChunkError();
    }

    public <E> Optional<E> get(int x, int y, int z, Key<? extends Value<E>> key) {
        return Optional.empty();
    }

    public <E, V extends Value<E>> Optional<V> getValue(int x, int y, int z, Key<V> key) {
        return Optional.empty();
    }

    public boolean supports(int x, int y, int z, Key<?> key) {
        return false;
    }

    public Set<Key<?>> keys(int x, int y, int z) {
        return Collections.emptySet();
    }

    public Set<Value.Immutable<?>> getValues(int x, int y, int z) {
        return Collections.emptySet();
    }

    public <E> DataTransactionResult offer(int x, int y, int z, Key<? extends Value<E>> key, E value) {
        throw this.emptyChunkError();
    }

    public DataTransactionResult remove(int x, int y, int z, Key<?> key) {
        throw this.emptyChunkError();
    }

    public DataTransactionResult undo(int x, int y, int z, DataTransactionResult result) {
        throw this.emptyChunkError();
    }

    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, ValueContainer from) {
        throw this.emptyChunkError();
    }

    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, ValueContainer from, MergeFunction function) {
        throw this.emptyChunkError();
    }

    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, int xFrom, int yFrom, int zFrom, MergeFunction function) {
        throw this.emptyChunkError();
    }

    public boolean validateRawData(int x, int y, int z, DataView container) {
        return false;
    }

    public void setRawData(int x, int y, int z, DataView container) throws InvalidDataException {
        throw this.emptyChunkError();
    }

    public ScheduledUpdateList<BlockType> scheduledBlockUpdates() {
        throw this.emptyChunkError();
    }

    public ScheduledUpdateList<FluidType> scheduledFluidUpdates() {
        throw this.emptyChunkError();
    }

    public <E> DataTransactionResult offer(Key<? extends Value<E>> key, E value) {
        return DataTransactionResult.failNoData();
    }

    public DataTransactionResult offer(Value<?> value) {
        return DataTransactionResult.failNoData();
    }

    public <E> DataTransactionResult offerSingle(Key<? extends CollectionValue<E, ?>> key, E element) {
        return DataTransactionResult.failNoData();
    }

    public <K, V> DataTransactionResult offerSingle(Key<? extends MapValue<K, V>> key, K valueKey, V value) {
        return DataTransactionResult.failNoData();
    }

    public <K, V> DataTransactionResult offerAll(Key<? extends MapValue<K, V>> key, Map<? extends K, ? extends V> map) {
        return DataTransactionResult.failNoData();
    }

    public DataTransactionResult offerAll(MapValue<?, ?> value) {
        return DataTransactionResult.failNoData();
    }

    public DataTransactionResult offerAll(CollectionValue<?, ?> value) {
        return DataTransactionResult.failNoData();
    }

    public <E> DataTransactionResult offerAll(Key<? extends CollectionValue<E, ?>> key, Collection<? extends E> elements) {
        return DataTransactionResult.failNoData();
    }

    public <E> DataTransactionResult removeSingle(Key<? extends CollectionValue<E, ?>> key, E element) {
        return DataTransactionResult.failNoData();
    }

    public <K> DataTransactionResult removeKey(Key<? extends MapValue<K, ?>> key, K mapKey) {
        return DataTransactionResult.failNoData();
    }

    public DataTransactionResult removeAll(CollectionValue<?, ?> value) {
        return DataTransactionResult.failNoData();
    }

    public <E> DataTransactionResult removeAll(Key<? extends CollectionValue<E, ?>> key, Collection<? extends E> elements) {
        return DataTransactionResult.failNoData();
    }

    public DataTransactionResult removeAll(MapValue<?, ?> value) {
        return DataTransactionResult.failNoData();
    }

    public <K, V> DataTransactionResult removeAll(Key<? extends MapValue<K, V>> key, Map<? extends K, ? extends V> map) {
        return DataTransactionResult.failNoData();
    }

    public <E> DataTransactionResult tryOffer(Key<? extends Value<E>> key, E value) {
        return DataTransactionResult.failNoData();
    }

    public DataTransactionResult remove(Key<?> key) {
        return DataTransactionResult.failNoData();
    }

    public DataTransactionResult undo(DataTransactionResult result) {
        return DataTransactionResult.failNoData();
    }

    public DataTransactionResult copyFrom(ValueContainer that, MergeFunction function) {
        return DataTransactionResult.failNoData();
    }

    public <E> Optional<E> get(Key<? extends Value<E>> key) {
        return Optional.empty();
    }

    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        return Optional.empty();
    }

    public boolean supports(Key<?> key) {
        return false;
    }

    public Set<Key<?>> getKeys() {
        return Collections.emptySet();
    }

    public Set<Value.Immutable<?>> getValues() {
        return Collections.emptySet();
    }
}

