/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.level.chunk.storage;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.chunk.EntityChunk;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeEntityChunk
implements EntityChunk {
    private final class_3218 level;
    private final Vector3i chunkPosition;
    private final List<class_1297> entities;
    private @MonotonicNonNull SpongeChunkLayout chunkLayout;
    private @MonotonicNonNull Vector3i blockMin;
    private @MonotonicNonNull Vector3i blockMax;

    public SpongeEntityChunk(class_3218 level, Vector3i chunkPosition, List<class_1297> entities) {
        this.level = level;
        this.chunkPosition = chunkPosition;
        this.entities = entities;
    }

    public Vector3i min() {
        if (this.blockMin == null) {
            if (this.chunkLayout == null) {
                this.chunkLayout = new SpongeChunkLayout(this.level.method_31607(), this.level.method_31605());
            }
            this.blockMin = this.chunkLayout.forceToWorld(this.chunkPosition);
        }
        return this.blockMin;
    }

    public Vector3i max() {
        if (this.blockMax == null) {
            if (this.chunkLayout == null) {
                this.chunkLayout = new SpongeChunkLayout(this.level.method_31607(), this.level.method_31605());
            }
            this.blockMax = this.min().add(this.chunkLayout.chunkSize()).sub(1, 1, 1);
        }
        return this.blockMax;
    }

    public boolean contains(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    public Collection<? extends Player> players() {
        return this.entities.stream().filter(Player.class::isInstance).map(Player.class::cast).toList();
    }

    public Optional<Entity> entity(UUID uuid) {
        return this.entities.stream().filter(e -> e.method_5667().equals(uuid)).map(Entity.class::cast).findFirst();
    }

    public Collection<? extends Entity> entities() {
        return this.entities.stream().map(Entity.class::cast).toList();
    }

    public <T extends Entity> Collection<? extends T> entities(Class<? extends T> entityClass, AABB box, @Nullable Predicate<? super T> predicate) {
        class_238 mcAabb = VecHelper.toMinecraftAABB(box);
        return this.entities.stream().filter(e -> entityClass.isInstance(e) && e.method_5829().method_994(mcAabb)).map(entityClass::cast).filter(e -> predicate.test(e)).toList();
    }

    public Collection<? extends Entity> entities(AABB box, Predicate<? super Entity> filter) {
        class_238 mcAabb = VecHelper.toMinecraftAABB(box);
        return this.entities.stream().map(Entity.class::cast).filter(e -> ((class_1297)e).method_5829().method_994(mcAabb) && filter.test((Entity)e)).toList();
    }

    public VolumeStream<EntityChunk, Entity> entityStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ObjectArrayMutableEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableEntityBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(options, this, this, chunk -> chunk.entities.stream().filter(entity -> VecHelper.inBounds(entity.method_24515(), min, max)).map(entity -> new AbstractMap.SimpleEntry<class_2338, class_1297>(entity.method_24515(), (class_1297)entity)), VolumeStreamUtils.getOrCloneEntityWithVolume(shouldCarbonCopy, backingVolume, (class_1937)this.level), (key, entity) -> entity.method_5667(), (entityUuid, chunk) -> {
            class_1297 entity;
            class_1297 class_12972 = entity = shouldCarbonCopy ? (class_1297)backingVolume.entity((UUID)entityUuid).orElse(null) : (class_1297)chunk.entity(entityUuid).orElse(null);
            if (entity == null) {
                return null;
            }
            return new class_3545((Object)entity.method_24515(), (Object)entity);
        });
    }

    public <E extends Entity> E createEntity(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        this.checkPositionInChunk(position);
        return ((LevelBridge)this.level).bridge$createEntity(type, position, false);
    }

    public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        this.checkPositionInChunk(position);
        return ((LevelBridge)this.level).bridge$createEntity(type, position, true);
    }

    public Optional<Entity> createEntity(DataContainer container) {
        return Optional.ofNullable(((LevelBridge)this.level).bridge$createEntity(container, null, position -> VecHelper.inBounds(position, this.min(), this.max())));
    }

    public Optional<Entity> createEntity(DataContainer container, Vector3d position) {
        this.checkPositionInChunk(position);
        return Optional.ofNullable(((LevelBridge)this.level).bridge$createEntity(container, position, null));
    }

    public boolean spawnEntity(Entity entity) {
        this.entities.add((class_1297)entity);
        return true;
    }

    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Entity entity : entities) {
            this.spawnEntity(entity);
            list.add(entity);
        }
        return list;
    }

    public void filterEntities(Predicate<? super Entity> predicate) {
        this.entities.removeIf(e -> !predicate.test((Entity)e));
    }

    public void filterEntities(AABB box, Predicate<? super Entity> predicate) {
        class_238 mcAabb = VecHelper.toMinecraftAABB(box);
        this.entities.removeIf(e -> e.method_5829().method_994(mcAabb) && !predicate.test((Entity)e));
    }

    public <T extends Entity> void filterEntities(Class<? extends T> entityClass, AABB box, @Nullable Predicate<? super T> predicate) {
        class_238 mcAabb = VecHelper.toMinecraftAABB(box);
        this.entities.removeIf(e -> entityClass.isInstance(e) && e.method_5829().method_994(mcAabb) && (predicate == null || !predicate.test((Object)entityClass.cast(e))));
    }

    private void checkPositionInChunk(Vector3d position) {
        if (!VecHelper.inBounds(position, this.min(), this.max())) {
            throw new IllegalArgumentException("Supplied bounds are not within this chunk.");
        }
    }

    public List<class_1297> build() {
        return Collections.unmodifiableList(this.entities);
    }
}

