/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.portal;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5454;
import net.minecraft.class_9797;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.world.portal.Portal;
import org.spongepowered.api.world.portal.PortalLogic;
import org.spongepowered.api.world.server.ServerLocation;

public final class SpongeCompositePortalLogic
implements class_9797,
PortalLogic {
    private final List<class_9797> rules;

    public SpongeCompositePortalLogic(List<class_9797> rules) {
        this.rules = rules;
    }

    @Nullable
    public class_5454 method_60770(class_3218 sourceLevel, class_1297 entity, class_2338 portalPos) {
        return this.rules.stream().map(p -> p.method_60770(sourceLevel, entity, portalPos)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Optional<PortalLogic.PortalExitCalculator> exitCalculator() {
        return Optional.of((from, fromPos, entity) -> this.rules.stream().map(PortalLogic.class::cast).map(PortalLogic::exitCalculator).flatMap(Optional::stream).flatMap(c -> c.calculatePortalExit(from, fromPos, entity).stream()).findFirst());
    }

    public Optional<PortalLogic.PortalFinder> finder() {
        return Optional.of((at, range) -> this.rules.stream().map(PortalLogic.class::cast).map(PortalLogic::finder).flatMap(Optional::stream).flatMap(c -> c.findPortal(at, range).stream()).findFirst());
    }

    public Optional<PortalLogic.PortalGenerator> generator() {
        return Optional.of((at, axis) -> this.rules.stream().map(PortalLogic.class::cast).map(PortalLogic::generator).flatMap(Optional::stream).flatMap(c -> c.generatePortal(at, axis).stream()).findFirst());
    }

    public boolean teleport(Entity entity, ServerLocation destination, boolean generateDestinationPortal) {
        boolean searchRange = true;
        Axis axis = Axis.X;
        Optional<ServerLocation> foundPortal = this.finder().flatMap(finder -> finder.findPortal(destination, 1));
        if (foundPortal.isPresent()) {
            return foundPortal.map(Portal::position).map(arg_0 -> ((Entity)entity).setLocation(arg_0)).orElse(false);
        }
        if (generateDestinationPortal) {
            Optional<ServerLocation> generatedPortal = this.generator().flatMap(generator -> generator.generatePortal(destination, axis));
            return generatedPortal.map(Portal::position).map(arg_0 -> ((Entity)entity).setLocation(arg_0)).orElse(false);
        }
        return false;
    }
}

