/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.portal;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5454;
import net.minecraft.class_9797;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.world.portal.Portal;
import org.spongepowered.api.world.portal.PortalLogic;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.util.VecHelper;

public final class SpongeCustomPortalLogic
implements class_9797,
PortalLogic {
    private final PortalLogic.PortalExitCalculator exitCalculator;
    private final PortalLogic.PortalFinder finder;
    private final PortalLogic.PortalGenerator generator;
    private int searchRange = 16;
    private Axis axis = Axis.X;

    public SpongeCustomPortalLogic(PortalLogic.PortalExitCalculator calulator, PortalLogic.PortalFinder finder, PortalLogic.PortalGenerator generator) {
        this.exitCalculator = calulator;
        this.finder = finder;
        this.generator = generator;
    }

    public @Nullable class_5454 method_60770(class_3218 fromLevel, class_1297 entity, class_2338 fromPos) {
        Entity spongeEntity = (Entity)entity;
        return this.exitCalculator.calculatePortalExit((ServerWorld)fromLevel, VecHelper.toVector3i(fromPos), spongeEntity).flatMap(calcExit -> this.finder.findPortal(calcExit, this.searchRange).map(Portal::position).or(() -> this.generator.generatePortal(calcExit, this.axis).map(Portal::position)).map(realExit -> SpongeCustomPortalLogic.generateTransition(entity, realExit))).orElse(null);
    }

    private static class_5454 generateTransition(class_1297 entity, ServerLocation finalExit) {
        return new class_5454((class_3218)finalExit.world(), VecHelper.toVanillaVector3d(finalExit.position()), entity.method_18798(), entity.method_36454(), entity.method_36455(), class_5454.field_52247);
    }

    public Optional<PortalLogic.PortalExitCalculator> exitCalculator() {
        return Optional.of(this.exitCalculator);
    }

    public Optional<PortalLogic.PortalFinder> finder() {
        return Optional.of(this.finder);
    }

    public Optional<PortalLogic.PortalGenerator> generator() {
        return Optional.of(this.generator);
    }

    public boolean teleport(Entity entity, ServerLocation destination, boolean generateDestinationPortal) {
        Optional foundPortal = this.finder.findPortal(destination, this.searchRange);
        if (foundPortal.isPresent()) {
            return foundPortal.map(Portal::position).map(arg_0 -> ((Entity)entity).setLocation(arg_0)).orElse(false);
        }
        if (generateDestinationPortal) {
            Optional generatedPortal = this.generator.generatePortal(destination, this.axis);
            return generatedPortal.map(Portal::position).map(arg_0 -> ((Entity)entity).setLocation(arg_0)).orElse(false);
        }
        return false;
    }
}

