/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.portal;

import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.world.portal.PortalLogic;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeWorldManager;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeNetherPortalExitCalculator
implements PortalLogic.PortalExitCalculator {
    private final class_5321<class_1937> origin;
    private final class_5321<class_1937> target;
    private final @Nullable Double scale;

    public SpongeNetherPortalExitCalculator(ResourceKey origin, ResourceKey target, @Nullable Double scale) {
        this.origin = SpongeWorldManager.createRegistryKey(origin);
        this.target = SpongeWorldManager.createRegistryKey(target);
        this.scale = scale;
    }

    public Optional<ServerLocation> calculatePortalExit(ServerWorld from, Vector3i fromPos, Entity entity) {
        class_3218 fromLevel = (class_3218)from.world();
        if (!fromLevel.method_27983().equals(this.origin)) {
            return Optional.empty();
        }
        class_3218 toLevel = fromLevel.method_8503().method_3847(this.target);
        if (toLevel == null) {
            return Optional.empty();
        }
        double scale = this.calculateScale(fromLevel, toLevel);
        class_2338 exitPosition = toLevel.method_8621().method_39538((double)fromPos.x() * scale, (double)fromPos.y(), (double)fromPos.z() * scale);
        return Optional.of(ServerLocation.of((ServerWorld)((ServerWorld)toLevel), (Vector3i)VecHelper.toVector3i(exitPosition)));
    }

    private double calculateScale(class_3218 fromLevel, class_3218 toLevel) {
        if (this.scale != null) {
            return this.scale;
        }
        return class_2874.method_31109((class_2874)fromLevel.method_8597(), (class_2874)toLevel.method_8597());
    }
}

