/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.portal;

import java.util.Optional;
import net.minecraft.class_2246;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.portal.Portal;
import org.spongepowered.api.world.portal.PortalLogic;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.world.portal.SpongeEndPlatformGenerator;
import org.spongepowered.common.world.portal.SpongeNetherPortalExitCalculator;
import org.spongepowered.common.world.portal.SpongePortal;
import org.spongepowered.common.world.portal.SpongeSpawnPortalFinder;
import org.spongepowered.common.world.portal.SpongeTargetPortalFinder;
import org.spongepowered.math.vector.Vector3d;

public class SpongePortalLogicFactory
implements PortalLogic.Factory {
    public static final PortalLogic.PortalFinder NO_OP_PORTALFINDER = (at, range) -> Optional.of(new SpongePortal(at));

    public PortalLogic endPortal() {
        return (PortalLogic)class_2246.field_10027;
    }

    public PortalLogic endGateway() {
        return (PortalLogic)class_2246.field_10613;
    }

    public PortalLogic netherPortal() {
        return (PortalLogic)class_2246.field_10316;
    }

    public PortalLogic.PortalExitCalculator netherPortalExitCalculator(ResourceKey origin, ResourceKey target) {
        return new SpongeNetherPortalExitCalculator(origin, target, null);
    }

    public PortalLogic.PortalExitCalculator netherPortalExitCalculator(ResourceKey origin, ResourceKey target, double scale) {
        return new SpongeNetherPortalExitCalculator(origin, target, scale);
    }

    public PortalLogic.PortalExitCalculator targetCalculator(ResourceKey origin, ResourceKey target, Vector3d targetPos) {
        return new SpongeTargetPortalFinder(origin, target, targetPos);
    }

    public PortalLogic.PortalExitCalculator spawnCalculator(ResourceKey origin, ResourceKey target) {
        return new SpongeSpawnPortalFinder(origin, target);
    }

    public PortalLogic.PortalFinder netherPortalFinder() {
        return (PortalLogic.PortalFinder)this.netherPortal().finder().get();
    }

    public PortalLogic.PortalGenerator netherPortalGenerator() {
        return (PortalLogic.PortalGenerator)this.netherPortal().generator().get();
    }

    public PortalLogic.PortalGenerator endPlatformGenerator() {
        return SpongeEndPlatformGenerator.INSTANCE;
    }

    public PortalLogic.PortalFinder noOpFinder() {
        return NO_OP_PORTALFINDER;
    }

    public Portal portalOf(PortalLogic logic, ServerLocation position) {
        return new SpongePortal(position, logic);
    }

    public Portal portalOf(PortalLogic logic, ServerLocation position, AABB aabb) {
        return new SpongePortal(position, logic, aabb);
    }
}

