/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteReference;
import org.spongepowered.api.world.schematic.PaletteType;

public abstract class CachingPalette<T, R, D extends Palette<T, R>>
implements Palette<T, R> {
    protected final D delegate;
    protected final Map<Integer, Optional<T>> cache;

    protected CachingPalette(D delegate) {
        this.delegate = delegate;
        this.cache = new HashMap<Integer, Optional<T>>();
    }

    public PaletteType<T, R> type() {
        return this.delegate.type();
    }

    public int highestId() {
        return this.delegate.highestId();
    }

    public Optional<PaletteReference<T, R>> get(int id) {
        return this.delegate.get(id);
    }

    public Optional<T> get(int id, RegistryHolder holder) {
        return this.cache.computeIfAbsent(id, $ -> this.delegate.get(id, holder));
    }

    public OptionalInt get(T type) {
        return this.delegate.get(type);
    }

    public Stream<T> stream() {
        return this.delegate.stream();
    }

    public Stream<Map.Entry<T, Integer>> streamWithIds() {
        return this.delegate.streamWithIds();
    }

    public Palette.Mutable<T, R> asMutable(RegistryHolder registry) {
        return new MutableImpl(this.delegate.asMutable(registry));
    }

    public Palette.Immutable<T, R> asImmutable() {
        return new ImmutableImpl(this.delegate.asImmutable());
    }

    public static final class MutableImpl<T, R>
    extends CachingPalette<T, R, Palette.Mutable<T, R>>
    implements Palette.Mutable<T, R> {
        public MutableImpl(Palette.Mutable<T, R> delegate) {
            super(delegate);
        }

        public int orAssign(T type) {
            int id = ((Palette.Mutable)this.delegate).orAssign(type);
            this.cache.put(id, Optional.of(type));
            return id;
        }

        public boolean remove(T type) {
            ((Palette.Mutable)this.delegate).get(type).ifPresent(this.cache::remove);
            return ((Palette.Mutable)this.delegate).remove(type);
        }
    }

    public static final class ImmutableImpl<T, R>
    extends CachingPalette<T, R, Palette.Immutable<T, R>>
    implements Palette.Immutable<T, R> {
        public ImmutableImpl(Palette.Immutable<T, R> delegate) {
            super(delegate);
        }
    }
}

