/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteReference;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.common.world.schematic.MutableBimapPalette;

public final class ImmutableBimapPalette<T, R>
implements Palette.Immutable<T, R> {
    private final ImmutableBiMap<Integer, PaletteReference<T, R>> ids;
    private final ImmutableBiMap<PaletteReference<T, R>, Integer> idsr;
    private final PaletteType<T, R> paletteType;
    private final int maxId;
    private final Registry<R> registry;

    public ImmutableBimapPalette(PaletteType<T, R> paletteType, Registry<R> registry, BiMap<Integer, PaletteReference<T, R>> reference) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        reference.forEach((arg_0, arg_1) -> ((ImmutableBiMap.Builder)builder).put(arg_0, arg_1));
        this.ids = builder.build();
        this.idsr = this.ids.inverse();
        this.paletteType = paletteType;
        this.registry = registry;
        int maxId = 0;
        for (Integer id : this.ids.keySet()) {
            if (maxId >= id) continue;
            maxId = id;
        }
        this.maxId = maxId;
    }

    public PaletteType<T, R> type() {
        return this.paletteType;
    }

    public int highestId() {
        return this.maxId;
    }

    public OptionalInt get(T state) {
        PaletteReference<T, R> ref = MutableBimapPalette.createPaletteReference(state, this.paletteType, this.registry);
        Integer value = (Integer)this.idsr.get(ref);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    public Optional<PaletteReference<T, R>> get(int id) {
        return Optional.ofNullable((PaletteReference)this.ids.get((Object)id));
    }

    public Stream<T> stream() {
        return this.idsr.keySet().stream().map(ref -> (Optional)this.paletteType.resolver().apply(ref.value(), this.registry)).filter(Optional::isPresent).map(Optional::get);
    }

    public Stream<Map.Entry<T, Integer>> streamWithIds() {
        return this.ids.entrySet().stream().map(entry -> {
            Optional apply = (Optional)this.paletteType.resolver().apply(((PaletteReference)entry.getValue()).value(), this.registry);
            return apply.map(value -> new AbstractMap.SimpleEntry<Object, Integer>(value, (Integer)entry.getKey()));
        }).filter(Optional::isPresent).map(Optional::get);
    }

    public Palette.Mutable<T, R> asMutable(RegistryHolder holder) {
        return new MutableBimapPalette<T, R>(this.paletteType, this.registry);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableBimapPalette that = (ImmutableBimapPalette)o;
        return this.maxId == that.maxId && this.ids.equals(that.ids) && this.paletteType.equals(that.paletteType);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.paletteType, this.maxId);
    }
}

