/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.AbstractMap;
import java.util.BitSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteReference;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.common.world.schematic.ImmutableBimapPalette;

public final class MutableBimapPalette<T, R>
implements Palette.Mutable<T, R> {
    private static final int DEFAULT_ALLOCATION_SIZE = 64;
    private final BiMap<Integer, PaletteReference<T, R>> ids;
    private final BiMap<PaletteReference<T, R>, Integer> idsr;
    private final BitSet allocation = new BitSet(64);
    private final PaletteType<T, R> paletteType;
    private final Registry<R> registry;
    private int maxId = 0;

    public MutableBimapPalette(PaletteType<T, R> paletteType, Registry<R> registry) {
        this.ids = HashBiMap.create();
        this.idsr = this.ids.inverse();
        this.paletteType = paletteType;
        this.registry = registry;
    }

    public MutableBimapPalette(PaletteType<T, R> paletteType, Registry<R> registry, BiMap<PaletteReference<T, R>, Integer> reference) {
        this.ids = HashBiMap.create((int)reference.size());
        this.idsr = this.ids.inverse();
        this.paletteType = paletteType;
        this.registry = registry;
        reference.forEach((key, id) -> this.getOrAssignInternal((PaletteReference<T, R>)key));
    }

    public MutableBimapPalette(PaletteType<T, R> paletteType, Registry<R> registry, RegistryType<R> registryType, int expectedSize) {
        this.ids = HashBiMap.create((int)expectedSize);
        this.idsr = this.ids.inverse();
        this.paletteType = paletteType;
        this.registry = registry;
    }

    public PaletteType<T, R> type() {
        return this.paletteType;
    }

    public int highestId() {
        return this.maxId;
    }

    public OptionalInt get(T state) {
        PaletteReference<T, R> ref = MutableBimapPalette.createPaletteReference(state, this.paletteType, this.registry);
        Integer value = (Integer)this.idsr.get(ref);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    private int getOrAssignInternal(PaletteReference<T, R> ref) {
        Integer id = (Integer)this.idsr.get(ref);
        if (id == null) {
            int next = this.allocation.nextClearBit(0);
            if (this.maxId < next) {
                this.maxId = next;
            }
            this.allocation.set(next);
            this.ids.put((Object)next, ref);
            return next;
        }
        return id;
    }

    public int orAssign(T state) {
        PaletteReference<T, R> ref = MutableBimapPalette.createPaletteReference(state, this.paletteType, this.registry);
        return this.getOrAssignInternal(ref);
    }

    public Optional<PaletteReference<T, R>> get(int id) {
        return Optional.ofNullable((PaletteReference)this.ids.get((Object)id));
    }

    public Optional<T> get(int id, RegistryHolder holder) {
        return this.get(id).flatMap(ref -> {
            Optional byRegistry = (Optional)this.paletteType.resolver().apply(ref.value(), this.registry);
            if (!byRegistry.isPresent()) {
                return Objects.requireNonNull(holder, "RegistryHolder cannot be null").findRegistry(ref.registry()).flatMap(reg -> (Optional)this.type().resolver().apply(ref.value(), reg));
            }
            return byRegistry;
        });
    }

    public int assign(T state, int id) {
        if (this.maxId < id) {
            this.maxId = id;
        }
        this.allocation.set(id);
        PaletteReference<T, R> ref = MutableBimapPalette.createPaletteReference(state, this.paletteType, this.registry);
        this.ids.put((Object)id, ref);
        return id;
    }

    static <T, R> @NonNull PaletteReference<T, R> createPaletteReference(T state, PaletteType<T, R> paletteType, Registry<R> registry) {
        String string = (String)paletteType.stringifier().apply(registry, state);
        return PaletteReference.byString((RegistryType)registry.type(), (String)string);
    }

    public boolean remove(T state) {
        Integer id = (Integer)this.idsr.get(state);
        if (id == null) {
            return false;
        }
        this.allocation.clear(id);
        if (id == this.maxId) {
            this.maxId = this.allocation.previousSetBit(this.maxId);
        }
        this.ids.remove((Object)id);
        return true;
    }

    public Stream<T> stream() {
        HashBiMap copy = HashBiMap.create(this.idsr);
        return copy.keySet().stream().map(ref -> (Optional)this.paletteType.resolver().apply(ref.value(), this.registry)).filter(Optional::isPresent).map(Optional::get);
    }

    public Stream<Map.Entry<T, Integer>> streamWithIds() {
        HashBiMap copy = HashBiMap.create(this.ids);
        return copy.entrySet().stream().map(entry -> {
            Optional apply = (Optional)this.paletteType.resolver().apply(((PaletteReference)entry.getValue()).value(), this.registry);
            return apply.map(value -> new AbstractMap.SimpleEntry<Object, Integer>(value, (Integer)entry.getKey()));
        }).filter(Optional::isPresent).map(Optional::get);
    }

    public Palette.Immutable<T, R> asImmutable() {
        return new ImmutableBimapPalette<T, R>(this.paletteType, this.registry, this.ids);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableBimapPalette that = (MutableBimapPalette)o;
        return this.maxId == that.maxId && this.ids.equals(that.ids) && this.allocation.equals(that.allocation) && this.paletteType.equals(that.paletteType);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.allocation, this.paletteType, this.maxId);
    }
}

