/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import com.mojang.datafixers.DataFixer;
import io.leangen.geantyref.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_155;
import net.minecraft.class_2487;
import net.minecraft.class_4284;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.BlockStateSerializerDeserializer;
import org.spongepowered.common.block.entity.SpongeBlockEntityArchetypeBuilder;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.persistence.schematic.SchematicUpdater1_to_2;
import org.spongepowered.common.data.persistence.schematic.SchematicUpdater2_to_3;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.schematic.CachingPalette;
import org.spongepowered.common.world.schematic.MutableBimapPalette;
import org.spongepowered.common.world.schematic.SpongeSchematicBuilder;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.archetype.SpongeArchetypeVolume;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class SchematicTranslator
implements DataTranslator<Schematic> {
    private static final SchematicTranslator INSTANCE = new SchematicTranslator();
    private static final TypeToken<Schematic> TYPE_TOKEN = TypeToken.get(Schematic.class);
    private static final ConcurrentSkipListSet<String> MISSING_MOD_IDS = new ConcurrentSkipListSet();
    private static final DataContentUpdater V1_TO_2 = new SchematicUpdater1_to_2();
    private static final DataContentUpdater V2_TO_3 = new SchematicUpdater2_to_3();
    private static @Nullable DataFixer VANILLA_FIXER;

    public static SchematicTranslator get() {
        return INSTANCE;
    }

    private SchematicTranslator() {
    }

    public TypeToken<Schematic> token() {
        return TYPE_TOKEN;
    }

    public Schematic translate(DataView unprocessed) throws InvalidDataException {
        DataView updatedView;
        boolean needsFixers;
        DataView schematicView;
        int version;
        if (VANILLA_FIXER == null) {
            VANILLA_FIXER = SpongeCommon.server().method_3855();
        }
        if ((version = ((Integer)(schematicView = unprocessed.getView(Constants.Sponge.Schematic.SCHEMATIC).orElse(unprocessed)).getInt(Constants.Sponge.Schematic.VERSION).get()).intValue()) > 3) {
            throw new InvalidDataException(String.format("Unknown schematic version %d (current version is %d)", version, 3));
        }
        if (version == 1) {
            V2_TO_3.update((Object)((DataView)V1_TO_2.update((Object)schematicView)));
        } else if (version == 2) {
            V2_TO_3.update((Object)schematicView);
        }
        int dataVersion = (Integer)schematicView.getInt(Constants.Sponge.Schematic.DATA_VERSION).get();
        boolean bl = needsFixers = dataVersion < class_155.method_16673().method_37912().method_38494() && VANILLA_FIXER != null;
        if (needsFixers) {
            class_2487 compound = NBTTranslator.INSTANCE.translate(schematicView);
            class_2487 updated = class_4284.field_19214.method_48130(VANILLA_FIXER, compound, dataVersion);
            updatedView = NBTTranslator.INSTANCE.translate(updated);
        } else {
            updatedView = schematicView;
        }
        SpongeSchematicBuilder builder = new SpongeSchematicBuilder();
        Optional metadataView = updatedView.getView(Constants.Sponge.Schematic.METADATA);
        metadataView.ifPresent(metadata -> {
            metadata.getView(DataQuery.of((String[])new String[]{"."})).ifPresent(data -> {
                for (DataQuery key : data.keys(false)) {
                    if (metadata.contains(key)) continue;
                    metadata.set(key, data.get(key).get());
                }
            });
            String schematicName = metadata.getString(Constants.Sponge.Schematic.NAME).orElse("unknown");
            metadata.getStringList(Constants.Sponge.Schematic.REQUIRED_MODS).ifPresent(mods -> {
                for (String modId : mods) {
                    if (Sponge.pluginManager().plugin(modId).isPresent() || !MISSING_MOD_IDS.add(modId)) continue;
                    SpongeCommon.logger().warn("When attempting to load the Schematic: {} there is a missing modid {} some blocks/tiles/entities may not load correctly.", (Object)schematicName, (Object)modId);
                }
            });
            DataContainer meta = DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED);
            for (DataQuery key : metadata.keys(false)) {
                meta.set(key, metadata.get(key).get());
            }
            builder.metadata((DataView)meta);
        });
        short width = (Short)updatedView.getShort(Constants.Sponge.Schematic.WIDTH).orElseThrow(() -> new InvalidDataException("Missing value for: " + String.valueOf(Constants.Sponge.Schematic.WIDTH)));
        short height = (Short)updatedView.getShort(Constants.Sponge.Schematic.HEIGHT).orElseThrow(() -> new InvalidDataException("Missing value for: " + String.valueOf(Constants.Sponge.Schematic.HEIGHT)));
        short length = (Short)updatedView.getShort(Constants.Sponge.Schematic.LENGTH).orElseThrow(() -> new InvalidDataException("Missing value for: " + String.valueOf(Constants.Sponge.Schematic.LENGTH)));
        if (width <= 0 || height <= 0 || length <= 0) {
            throw new InvalidDataException(String.format("Schematic is larger than maximum allowable size (found: (%d, %d, %d) max: (%d, %<d, %<d)", width, (int)height, (int)length, 65535));
        }
        int[] offsetArray = updatedView.get(Constants.Sponge.Schematic.OFFSET).orElse(new int[3]);
        if (offsetArray.length != 3) {
            throw new InvalidDataException("Schematic offset was not of length 3");
        }
        Vector3i offset = new Vector3i(offsetArray[0], offsetArray[1], offsetArray[2]);
        SpongeArchetypeVolume archetypeVolume = new SpongeArchetypeVolume(offset, new Vector3i((int)width, (int)height, (int)length), (RegistryHolder)Sponge.server());
        updatedView.getView(Constants.Sponge.Schematic.BLOCK_CONTAINER).ifPresent(blocks -> SchematicTranslator.deserializeBlockContainer(blocks, archetypeVolume, width, length, offset, needsFixers));
        updatedView.getView(Constants.Sponge.Schematic.BIOME_CONTAINER).ifPresent(biomes -> SchematicTranslator.deserializeBiomeContainer(biomes, archetypeVolume, width, length, offset));
        updatedView.getViewList(Constants.Sponge.Schematic.ENTITIES).map(Collection::stream).orElse(Stream.of(new DataView[0])).filter(entity -> entity.contains(Constants.Sponge.Schematic.ENTITIES_POS, new DataQuery[]{Constants.Sponge.Schematic.ENTITIES_ID})).map(SchematicTranslator.deserializeEntityArchetype()).filter(Optional::isPresent).map(Optional::get).forEach(archetypeVolume::addEntity);
        builder.volume(archetypeVolume);
        return builder.build();
    }

    private static Function<DataView, Optional<EntityArchetypeEntry>> deserializeEntityArchetype() {
        return view -> {
            String typeId = (String)view.getString(Constants.Sponge.Schematic.ENTITIES_ID).get();
            ResourceKey key = ResourceKey.resolve((String)typeId);
            @NonNull Optional entityType = Sponge.game().registry((RegistryType)RegistryTypes.ENTITY_TYPE).findValue(key);
            return entityType.map(type -> {
                List pos = (List)view.getDoubleList(Constants.Sponge.Schematic.ENTITIES_POS).orElseThrow(() -> new IllegalStateException("Schematic not abiding by format, all Entities must have an x y z pos"));
                EntityArchetype.Builder builder = SpongeEntityArchetypeBuilder.pooled().type((EntityType<?>)type);
                view.getView(Constants.Sponge.Schematic.BLOCKENTITY_DATA).ifPresent(arg_0 -> ((EntityArchetype.Builder)builder).entityData(arg_0));
                Vector3d entityPosition = new Vector3d(((Double)pos.get(0)).doubleValue(), ((Double)pos.get(1)).doubleValue(), ((Double)pos.get(2)).doubleValue());
                return EntityArchetypeEntry.of((EntityArchetype)builder.build(), (Vector3d)entityPosition);
            });
        };
    }

    private static @NonNull Consumer<DataView> deserializeBlockEntities(Vector3i offset, SpongeArchetypeVolume archetypeVolume, boolean needsFixers) {
        return blockEntityData -> {
            int[] pos = (int[])blockEntityData.get(Constants.Sponge.Schematic.BLOCKENTITY_POS).orElseThrow(() -> new IllegalStateException("Schematic not abiding by format, all BlockEntities must have an x y z pos"));
            blockEntityData.getString(Constants.Sponge.Schematic.BLOCKENTITY_ID).map(ResourceKey::resolve).map(key -> Sponge.game().registry((RegistryType)RegistryTypes.BLOCK_ENTITY_TYPE).findValue(key)).filter(Optional::isPresent).map(Optional::get).ifPresent(type -> {
                int x = pos[0] + offset.x();
                int y = pos[1] + offset.y();
                int z = pos[2] + offset.z();
                BlockEntityArchetype.Builder builder = SpongeBlockEntityArchetypeBuilder.pooled().state(archetypeVolume.block(x, y, z)).blockEntity(type);
                blockEntityData.getView(Constants.Sponge.Schematic.BLOCKENTITY_DATA).ifPresent(arg_0 -> ((BlockEntityArchetype.Builder)builder).blockEntityData(arg_0));
                archetypeVolume.addBlockEntity(x, y, z, builder.build());
            });
        };
    }

    private static void deserializeBlockContainer(DataView view, SpongeArchetypeVolume archetypeVolume, int width, int length, Vector3i offset, boolean needsFixers) {
        DataView paletteMap = (DataView)view.getView(Constants.Sponge.Schematic.BLOCK_PALETTE).orElseThrow(() -> new InvalidDataException("Missing BlockPalette as required by Schematic Specification"));
        Set paletteKeys = paletteMap.keys(false);
        MutableBimapPalette palette = new MutableBimapPalette((PaletteType)PaletteTypes.BLOCK_STATE_PALETTE.get(), Sponge.game().registry((RegistryType)RegistryTypes.BLOCK_TYPE), RegistryTypes.BLOCK_TYPE, paletteKeys.size());
        for (DataQuery key : paletteKeys) {
            BlockState state = BlockStateSerializerDeserializer.deserialize((String)key.parts().get(0)).orElseGet(() -> (BlockState)((BlockType)BlockTypes.BEDROCK.get()).defaultState());
            palette.assign(state, (Integer)paletteMap.getInt(key).orElseThrow(() -> new IllegalStateException("Somehow got a missing biome in the palette map for schematic")));
        }
        byte[] blockData = (byte[])view.get(Constants.Sponge.Schematic.BLOCK_DATA).orElseThrow(() -> new InvalidDataException("Missing BlockData for Schematic"));
        SchematicTranslator.readByteArrayData(width, width * length, offset, new CachingPalette.MutableImpl(palette), blockData, archetypeVolume, BlockVolume.Modifiable::setBlock);
        view.getViewList(Constants.Sponge.Schematic.BLOCKENTITY_CONTAINER).ifPresent(tileData -> tileData.forEach(SchematicTranslator.deserializeBlockEntities(offset, archetypeVolume, needsFixers)));
    }

    private static void deserializeBiomeContainer(DataView view, SpongeArchetypeVolume archetypeVolume, int width, int length, Vector3i offset) {
        DataView biomeMap = (DataView)view.getView(Constants.Sponge.Schematic.BIOME_PALETTE).orElseThrow(() -> new InvalidDataException("Missing BiomePalette as required by the schematic spec"));
        Set biomeKeys = biomeMap.keys(false);
        Registry biomeRegistry = VolumeStreamUtils.nativeToSpongeRegistry(SpongeCommon.server().method_30611().method_30530(class_7924.field_41236));
        MutableBimapPalette<Biome, Biome> biomePalette = new MutableBimapPalette<Biome, Biome>((PaletteType<Biome, Biome>)((PaletteType)PaletteTypes.BIOME_PALETTE.get()), (Registry<Biome>)biomeRegistry, (RegistryType<Biome>)RegistryTypes.BIOME, biomeKeys.size());
        for (DataQuery biomeKey : biomeKeys) {
            ResourceKey key = ResourceKey.resolve((String)((String)biomeKey.parts().get(0)));
            Biome biome = (Biome)biomeRegistry.findValue(key).get();
            biomePalette.assign(biome, (Integer)biomeMap.getInt(biomeKey).get());
        }
        byte[] biomeData = (byte[])view.get(Constants.Sponge.Schematic.BIOME_DATA).orElseThrow(() -> new InvalidDataException("Missing BlockData for Schematic"));
        SchematicTranslator.readByteArrayData(width, width * length, offset, biomePalette, biomeData, archetypeVolume, BiomeVolume.Modifiable::setBiome);
    }

    private static <Buffer, Type, ParentType> void readByteArrayData(int width, int i1, Vector3i offset, Palette<Type, ParentType> palette, byte[] data, Buffer buffer, PostSetter<Buffer, Type> setter) {
        int index = 0;
        int i = 0;
        int value = 0;
        int varint_length = 0;
        while (i < data.length) {
            value = 0;
            varint_length = 0;
            while (true) {
                value |= (data[i] & 0x7F) << varint_length++ * 7;
                if (varint_length > 5) {
                    throw new RuntimeException("VarInt too big (probably corrupted data)");
                }
                if ((data[i] & 0x80) != 128) {
                    ++i;
                    break;
                }
                ++i;
            }
            int y = index / i1;
            int z = index % i1 / width;
            int x = index % i1 % width;
            Object state = palette.get(value, (RegistryHolder)Sponge.game()).get();
            setter.apply(buffer, x + offset.x(), y + offset.y(), z + offset.z(), state);
            ++index;
        }
    }

    public DataContainer translate(Schematic schematic) throws InvalidDataException {
        DataContainer data = DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED);
        DataView view = data.createView(Constants.Sponge.Schematic.SCHEMATIC);
        this.addTo(schematic, view);
        return data;
    }

    public DataView addTo(Schematic schematic, DataView data) {
        BlockState state;
        int x0;
        int x;
        int z0;
        int z;
        int y0;
        ByteArrayOutputStream buffer2;
        int xMin = schematic.min().x();
        int yMin = schematic.min().y();
        int zMin = schematic.min().z();
        int width = schematic.size().x();
        int height = schematic.size().y();
        int length = schematic.size().z();
        if (width > 65535 || height > 65535 || length > 65535) {
            throw new IllegalArgumentException(String.format("Schematic is larger than maximum allowable size (found: (%d, %d, %d) max: (%d, %<d, %<d)", width, height, length, 65535));
        }
        data.set(Constants.Sponge.Schematic.WIDTH, (Object)((short)width));
        data.set(Constants.Sponge.Schematic.HEIGHT, (Object)((short)height));
        data.set(Constants.Sponge.Schematic.LENGTH, (Object)((short)length));
        data.set(Constants.Sponge.Schematic.VERSION, (Object)3);
        data.set(Constants.Sponge.Schematic.DATA_VERSION, (Object)class_155.method_16673().method_37912().method_38494());
        for (DataQuery metaKey : schematic.metadata().keys(false)) {
            data.set(Constants.Sponge.Schematic.METADATA.then(metaKey), schematic.metadata().get(metaKey).get());
        }
        HashSet<String> requiredMods = new HashSet<String>();
        int[] offset = new int[]{xMin, yMin, zMin};
        data.set(Constants.Sponge.Schematic.OFFSET, (Object)offset);
        if (schematic.blockPalette().highestId() != 0) {
            DataView blockData = data.createView(Constants.Sponge.Schematic.BLOCK_CONTAINER);
            Palette.Mutable palette = schematic.blockPalette().asMutable((RegistryHolder)Sponge.server());
            try {
                buffer2 = new ByteArrayOutputStream(width * height * length);
                try {
                    for (int y = 0; y < height; ++y) {
                        y0 = yMin + y;
                        for (z = 0; z < length; ++z) {
                            z0 = zMin + z;
                            for (x = 0; x < width; ++x) {
                                x0 = xMin + x;
                                state = schematic.block(x0, y0, z0);
                                SchematicTranslator.writeIdToBuffer(buffer2, palette.orAssign((Object)state));
                            }
                        }
                    }
                    blockData.set(Constants.Sponge.Schematic.BLOCK_DATA, (Object)buffer2.toByteArray());
                }
                finally {
                    buffer2.close();
                }
            }
            catch (IOException buffer2) {
                // empty catch block
            }
            Registry blockRegistry = VolumeStreamUtils.nativeToSpongeRegistry(SpongeCommon.server().method_30611().method_30530(class_7924.field_41254));
            SchematicTranslator.writePaletteToView(blockData, palette, blockRegistry, Constants.Sponge.Schematic.BLOCK_PALETTE, BlockState::type, requiredMods);
            List blockEntities = schematic.blockEntityArchetypes().entrySet().stream().map(entry -> {
                DataContainer container = DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED);
                Vector3i pos = (Vector3i)entry.getKey();
                BlockEntityArchetype archetype = (BlockEntityArchetype)entry.getValue();
                DataContainer entityData = archetype.blockEntityData();
                int[] apos = new int[]{pos.x() - xMin, pos.y() - yMin, pos.z() - zMin};
                container.set(Constants.Sponge.Schematic.BLOCKENTITY_POS, (Object)apos);
                container.set(Constants.Sponge.Schematic.BLOCKENTITY_DATA, (Object)entityData);
                ResourceKey key = archetype.blockEntityType().key(RegistryTypes.BLOCK_ENTITY_TYPE);
                container.set(Constants.Sponge.Schematic.ENTITIES_ID, (Object)key.asString());
                String namespace = key.namespace();
                if (!"minecraft".equals(namespace)) {
                    requiredMods.add(namespace);
                }
                return container;
            }).collect(Collectors.toList());
            blockData.set(Constants.Sponge.Schematic.BLOCKENTITY_CONTAINER, blockEntities);
        }
        if (schematic.biomePalette().highestId() != 0) {
            DataView biomeContainer = data.createView(Constants.Sponge.Schematic.BIOME_CONTAINER);
            Palette.Mutable biomePalette = schematic.biomePalette().asMutable((RegistryHolder)Sponge.game());
            try {
                buffer2 = new ByteArrayOutputStream(width * height * length);
                try {
                    for (int y = 0; y < height; ++y) {
                        y0 = yMin + y;
                        for (z = 0; z < length; ++z) {
                            z0 = zMin + z;
                            for (x = 0; x < width; ++x) {
                                x0 = xMin + x;
                                state = schematic.biome(x0, y0, z0);
                                SchematicTranslator.writeIdToBuffer(buffer2, biomePalette.orAssign((Object)state));
                            }
                        }
                    }
                    biomeContainer.set(Constants.Sponge.Schematic.BIOME_DATA, (Object)buffer2.toByteArray());
                }
                finally {
                    buffer2.close();
                }
            }
            catch (IOException buffer3) {
                // empty catch block
            }
            Registry biomeRegistry = VolumeStreamUtils.nativeToSpongeRegistry(SpongeCommon.server().method_30611().method_30530(class_7924.field_41236));
            SchematicTranslator.writePaletteToView(biomeContainer, biomePalette, biomeRegistry, Constants.Sponge.Schematic.BIOME_PALETTE, Function.identity(), requiredMods);
        }
        List entities = schematic.entityArchetypesByPosition().stream().map(entry -> {
            DataContainer container = DataContainer.createNew((DataView.SafetyMode)DataView.SafetyMode.NO_DATA_CLONED);
            ArrayList<Double> entityPosition = new ArrayList<Double>();
            entityPosition.add(entry.position().x());
            entityPosition.add(entry.position().y());
            entityPosition.add(entry.position().z());
            container.set(Constants.Sponge.Schematic.ENTITIES_POS, entityPosition);
            ResourceKey key = entry.archetype().type().key(RegistryTypes.ENTITY_TYPE);
            if (!"minecraft".equals(key.namespace())) {
                requiredMods.add(key.namespace());
            }
            container.set(Constants.Sponge.Schematic.ENTITIES_ID, (Object)key.toString());
            DataContainer entityData = entry.archetype().entityData();
            container.set(Constants.Sponge.Schematic.BLOCKENTITY_DATA, (Object)entityData);
            return container;
        }).collect(Collectors.toList());
        data.set(Constants.Sponge.Schematic.ENTITIES, entities);
        if (!requiredMods.isEmpty()) {
            data.set(Constants.Sponge.Schematic.METADATA.then(Constants.Sponge.Schematic.REQUIRED_MODS), requiredMods);
        }
        return data;
    }

    private static <T, P> void writePaletteToView(DataView view, Palette.Mutable<T, P> palette, Registry<P> parentRegistryType, DataQuery paletteQuery, Function<T, P> parentGetter, Set<String> requiredMods) {
        palette.streamWithIds().forEach(entry -> {
            String stringified = (String)palette.type().stringifier().apply(parentRegistryType, entry.getKey());
            view.set(paletteQuery.then(stringified), entry.getValue());
            ResourceKey blockKey = (ResourceKey)parentRegistryType.findValueKey(parentGetter.apply(entry.getKey())).orElseThrow(() -> new IllegalStateException("Somehow have a BlockState that is not registered in the global BlockType registry"));
            if (!"minecraft".equals(blockKey.namespace())) {
                requiredMods.add(blockKey.namespace());
            }
        });
    }

    public static void writeIdToBuffer(ByteArrayOutputStream buffer, int orAssign) {
        int id = orAssign;
        while ((id & 0xFFFFFF80) != 0) {
            buffer.write(id & 0x7F | 0x80);
            id >>>= 7;
        }
        buffer.write(id);
    }

    static interface PostSetter<V, T> {
        public void apply(V var1, int var2, int var3, int var4, T var5);
    }
}

